//                                    Copyright John V. Rodley   1994
//
// UTILS.C - Various utilities for dealing with lists and other things.
//

#include <stddef.h>     /* Multi-threads live in mt directory.    */
#include <ctype.h>
#include <malloc.h>
#include <share.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include "utils.h"


int bVerbose = 0;
char buffer[BLOCKSIZE];

// AddStructToList - Add the specified structure to the specified list
// unless the list is full.  list is null terminated, unless full.
// return 0 if OK, 1 otherwise.
//
int AddStructToList( char *pSeg, char **pp, unsigned uItemSize, unsigned uMaxItems )
{
char *p;
unsigned loop;

if(( p = malloc( uItemSize )) == NULL )
   {
   printf( "malloc( %u ) failed\n", uItemSize ); 
   goto ErrorReturn;
   }
   
memmove( p, pSeg, uItemSize );

for( loop = 0; pp[loop] != NULL && ( loop < uMaxItems ); loop++ );

if( loop == uMaxItems )
   {
   printf( "loop = %u exceeded uMaxItems = %u\n", loop, uMaxItems ); 
	goto ErrorReturn;
   }

pp[loop] = p;

return( 0 );

ErrorReturn:
printf( "AddStructToList  ERROR\n" );
return( 1 );

}  /* AddStructToList */

// ClearList - Free all the items in this null terminated list, and 
// null-out the list itself.
void ClearList( char **pp, unsigned short itemsize, unsigned short maxitems )
{
	unsigned short i;
	for( i = 0; pp[i] != NULL && i < maxitems; i++ )
		free( pp[i] );
   memset( pp, '\0', itemsize*maxitems );
}
    
int CopyFileSection( FILE *in_fp, FILE *out_fp, long lSize )
{
    unsigned remainder;
    unsigned increments, size;
    unsigned loop;

    if( lSize <= 0L )
       goto ErrorReturn;

    /******************** COPY OVER UNTOUCHED SECTION OF FILE ****************/
    increments = (unsigned )(lSize/(long)BLOCKSIZE);
    remainder = (unsigned )(lSize%(long )BLOCKSIZE);

    for( loop = 0; loop <= increments; loop++ )
      {
      if( loop == increments )
         {
         if(( size = remainder ) == 0 )
            break;
         }
      else
         size = BLOCKSIZE;

      if( fread( buffer, size, 1, in_fp ) != 1 )
         goto ErrorReturn;

      if( fwrite( buffer, size, 1, out_fp ) != 1 )
        goto ErrorReturn;

      }
return( 0 );

ErrorReturn:

printf( "CopyFileSection ERROR\n" );
printf( "loop %d increments %d remainder %d size %d lSize %ldL\n", loop, increments, remainder, size, lSize );
printf( "in %ldL  out %ldL\n", ftell( in_fp ), ftell( out_fp ));

return( 1 );

}   /* CopyFileSection */

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

int dump( line, size, offset, type )
   char far *line;
   unsigned size;
   unsigned long offset;
   int type;
{
unsigned loop;
unsigned kar;
int temp;
unsigned limit;
char buffer[255];
unsigned length;

if( type == 1 )
   printf( "FTDUMP %p (%lx)  %u bytes\n", line, line, size );

length = size;

memset( buffer, '\0', sizeof( buffer ));

for( loop = 0; size > 0; loop++ )
      {
      if( type == 1 )
         printf( "%p  ", line + (loop * 16));
      else
         printf( "%8.8lx  ", offset + (long )(loop * 16));

        if( size < 16 )
            limit = size;
        else
            limit = 16;

      for( kar = 0; kar < limit; kar++ )
         {
         if((unsigned )line[kar+(loop*16)] < (char)16 )
            printf( "0%hx ", (char )line[kar+(loop*16)] );
         else
            {
            temp = (char )line[kar+(loop*16)];
            temp &= 0x00FF;
            printf( "%2hx ", temp );
            }
         }

      if( size < 16 )
	      for( kar = limit; kar < 16; kar++ )
            printf( "?? " );

      printf( "    " );

      for( kar = 0; kar < limit; kar++ )
         {
         if( isprint( line[kar+(loop*16)] ))
            printf( "%c", line[kar+(loop*16)] );
         else
            printf( " " );
         }

      printf( "\n" );

      if( size < 16 )
         break;

      size -= 16;

      }

   printf( "\n" );

return( 0 );

}  /* dump */


long FileLength( infile )
    char *infile;
    {

    FILE *in_fp = NULL;
    long lfSize = 0L;

    if(( in_fp = fopen( infile, "rb" )) == NULL )
      {
      printf(  "2 Can't open %s\n", infile );
      goto ErrorReturn;
      }

    if( fseek( in_fp, 0L, SEEK_END ))
      {
      printf(  "Cant seek\n" );
      goto ErrorReturn;
      }

    lfSize = ftell( in_fp );

ErrorReturn:

    fclose( in_fp );

return( lfSize );

}     /* FileLength */

int ftdump( char *line, unsigned size )
   {
   return( dump( line, size, 0L, 1 ));
   }

// GetNameField - read the pascal style string at pField into pName
// and set *pNext to the next string, while setting *puLength to the
// length of the string.
int GetNameField( char *pField, char *pName, char **pNext, unsigned *puLength )
{

unsigned uLength;
char *ptr;

ptr = (char *)&uLength;
ptr[0] = pField[0];
ptr[1] = '\0';
*puLength = uLength;

memmove( pName, &pField[1], uLength );
pName[uLength] = '\0';
*pNext = &pField[uLength+1];

return( 0 );

}  /* GetNameField */

// ReadSegmentIntoLump - Read the lSize lump of data at lLoc in infile
// into Lump.  
// return 0 if OK, 1 otherwise.
int ReadSegmentIntoLump( char *infile, long lLoc, long lSize, char *Lump )
    {
    FILE *in_fp = NULL;
    FILE *out_fp = NULL;
    unsigned size;

    if(( in_fp = fopen( infile, "rb" )) == NULL )
      {
      printf(  "3 Can't open %s\n", infile );
      goto ErrorReturn;
      }

    if( fseek( in_fp, lLoc, SEEK_SET ))
      {
      printf(  "Cant seek\n" );
      goto ErrorReturn;
      }

   size = (unsigned )lSize;

   if( fread( Lump, size, 1, in_fp ) != 1 )
      goto ErrorReturn;

   fclose( in_fp );

return( 0 );

ErrorReturn:

   printf( "ReadSegmentIntoLump ERROR\n" );
   printf( "infile %s, lloc %ldL, lsize %ldL, Lump %p\n", infile, lLoc, lSize, Lump );
   if( in_fp != NULL )
     fclose( in_fp );

return( -1 );

}                     /* ReadSegmentIntoLump */


/* hatou - convert a hex ascii value to an unsigned.   The ascii value
   may include the 0x prefix or the 'H' suffix.
*/
unsigned hatou( char *szHexValue, unsigned *puError )
{
int loop;
int length;
unsigned uValue;
int iMultiplier;
unsigned uTempValue, gribble;

length = strlen( szHexValue );

uValue = 0;
iMultiplier = 1;
uTempValue = 0;
*puError = 0;

for( loop = length-1; loop >= 0; loop-- )
   {
   gribble = 0;
   if(( szHexValue[loop] <= '9' ) && ( szHexValue[loop] >= '0' ))
      uTempValue = szHexValue[loop] - '0';
   else
      {
      if(( szHexValue[loop] <= 'F' ) && ( szHexValue[loop] >= 'A' ))
         uTempValue = ( szHexValue[loop] - 'A' ) + 10;
      else
         {
         switch( szHexValue[loop] )
            {
            case 'h':
            case 'H':
            case 'x':
            case 'X':
               gribble = 1;
               break;
            default:
               uTempValue = 0;
               *puError = 1;
               break;
            }
         }
      }
   if( gribble )     /* account for possible trailing h or leading 0x */
      continue;
   uValue += ( uTempValue * iMultiplier );
   iMultiplier *= 16;
   }

return( uValue );

}  /* hatou */

