/*
**  STRDELCH.C - Removes specified character(s) from a string
**
**  public domain demo by Bob Stout
*/

#include <stdio.h>
#include <string.h>

char *strdel(char *string, const char *lose)
{
      if (!string || !*string)
            return NULL;
      if (lose)
      {
            char *s;

            for (s = string; *s; ++s)
            {
                  if (strchr(lose, *s))
                  {
                        strcpy(s, s + 1);
                        --s;
                  }
            }
      }
      return string;
}

#ifdef TEST

main(int argc, char *argv[])
{
      char *strng, *delstrng;

      if (3 > argc--)
      {
            puts("Usage: STRDELCH char(s)_to_delete string_1 [...string_N]");
            return -1;
      }
      else  delstrng = *(++argv);
      while (--argc)
      {
            strng = *(++argv);
            printf("strdelch(\"%s\", \"%s\") => ", delstrng, strng);
            printf("\"%s\"\n", strdel(strng, delstrng));
      }
      return 0;
}

#endif /* TEST */
