;note: this module has been modified for the EARTH demo.  Do not attempt
;to use for any other purpose

;fade_out
;fade_in
;Fix_TGA_palette

PALETTE_NUMBER = 256       ;normally 256
;
CurPalette  db 256 dup (0,0,0)
;
macro       Decrease source
            local @@Done
            cmp source,0
            jz @@Done
            dec source
@@Done:     exitm
endm        Decrease
;
;si = offset to palette
;cx = number of colors to write
;al = starting palette register
;
;DESTROYS: dx,si,cx
;
MACRO       SetPalette
            mov     dx,cx
            add     cx,cx
            add     cx,dx
            mov     dx,03c8h
            out     dx,al
            inc     dx
            cld
            rep outsb
ENDM        SetPalette
;
macro       WaitForRetrace
            local @@WaitHi, @@WaitLo
            mov dx,3DAh
@@WaitHi:   in al,dx
            test al,8
            jnz @@WaitHi
@@WaitLo:   in al,dx
            test al,8
            jz @@WaitLo
endm        WaitForRetrace
;
;fades out the palette currently loaded to black
PROC        fade_out
            mov cx,64
@@NextLoop: push cx

        push es di ds si
            ;**** map the image to the planet and display it ****
            mov ax,0A000h
            mov es,ax
            xor di,di
            call MapIt

            ;**** rotate the planet a little ****
            call RotateIt
        pop si ds di es

            WaitForRetrace                ;wait for a vertical retrace
            mov cx,PALETTE_NUMBER
@@NextColor:      mov dx,3C7h                   ;\
                  mov al,cl                     ; \ send out the color number
                  dec al                        ; /
                  out dx,al                     ;/
                  mov dx,3C9h                   ;DX = DAC_DATA
                  in al,dx                      ;\
                  Decrease al                   ; > BL = red
                  mov bl,al                     ;/
                  in al,dx                      ;\
                  Decrease al                   ; > BH = green
                  mov bh,al                     ;/
                  in al,dx                      ;\
                  Decrease al                   ; > AH = blue
                  mov ah,al                     ;/
                  mov dx,3C8h                   ;\
                  mov al,cl                     ; \ send out the color number
                  dec al                        ; /
                  out dx,al                     ;/
                  mov dx,3C9h                   ;DX = DAC_DATA
                  mov al,bl                     ;\ send out new red
                  out dx,al                     ;/
                  mov al,bh                     ;\ send out new green
                  out dx,al                     ;/
                  mov al,ah                     ;\ send out new blue
                  out dx,al                     ;/

                  dec cx                        ;\ loop until all colors
                  jnz @@NextColor               ;/ are done
            pop cx
            dec cx                        ;\ loop until all cycles are done
            jnz @@NextLoop                ;/
            ret                           ;return
ENDP        fade_out
; 
;fades from palette1 to palette2
;
;           DS:SI ==> palette1 (starting palette)
;           ES:DI ==> palette2 (desired palette)
proc        fade_in
            ;**** converge the current palette to the desired one ****
@@FadeLoop: push si di
            mov cx,PALETTE_NUMBER*3
            xor bx,bx
            cld
@@NextColor:mov al,[byte es:di]
            cmp [byte ds:si],al
            jz @@ColorDone
            jb @@Increment
@@Decrement:dec [byte ds:si]
            or bx,1             ;set a flag that we're not perfect yet
            jmp @@ColorDone
@@Increment:inc [byte ds:si]
            or bx,1             ;set a flag that we're not perfect yet
@@ColorDone:inc si
            inc di
            dec cx
            jnz @@NextColor
            pop di si
            cmp bx,0            ;if we're perfect, then quit
            jz @@Done

            ;**** load in the new palette ****
            push si di
            mov cx,PALETTE_NUMBER
            xor al,al
            SetPalette
            pop di si

        push es di ds si
            ;**** map the image to the planet and display it ****
            mov ax,0A000h
            mov es,ax
            xor di,di
            call MapIt

            ;**** rotate the planet a little ****
            call RotateIt
        pop si ds di es
            
            ;**** wait for a vertical retrace ****
            WaitForRetrace
            jmp @@FadeLoop

@@Done:     ret
endp        fade_in
; 
;convert a palette stored in TGA format (all components from 0 to 255 and
;components stored in BGR order) to normal format (all components from
;0 to 63 and stored in RGB order)
;
;           DS:SI ==> palette to convert
proc        Fix_TGA_palette
            mov cx,PALETTE_NUMBER   ;CX = number of colors to process
@@FixPal:   mov bl,[ds:si+2]        ;\ load in Red component
            shr bl,2                ;/
            mov ah,[ds:si+1]        ;\ load in Green component
            shr ah,2                ;/
            mov al,[ds:si+0]        ;\ load in Blue component
            shr al,2                ;/
            mov [ds:si+0],bl        ;write out Red component
            mov [ds:si+1],ah        ;write out Green component
            mov [ds:si+2],al        ;write out Blue
            add si,3                ;point to next attribute
            loop @@FixPal           ;loop until we're done

            ret                     ;return
endp        Fix_TGA_palette
; 
