PlanetRow = 100             ;\ these are the coordinates of the center
PlanetCol = 160             ;/ of the world when displaying the planet
RotateAngle = 1             ;amount to rotate planet (must be positive)
;
MapAngle    dw 0            ;starting angle to display planet at
;
;rotate the planet a little
proc        RotateIt            
            sub [cs:MapAngle],RotateAngle
            cmp [cs:MapAngle],0
            jge @@AngleOkay
            add [cs:MapAngle],MapWidth
@@AngleOkay:ret
endp        RotateIt
;
;           ES:DI ==> screen buffer
proc        MapIt
            cld

            add di,((PlanetRow-SphereHeight/2)*320+(PlanetCol-SphereWidth/2))
                                                ;for each row: += 320

            mov ax,SphereSegment
            mov ds,ax
            mov si,offset SphereData            ;for each row: += SphereWidth

            mov ax,MapSegment
            mov fs,ax
            mov bx,offset MapData               ;for each row: += MapWidth

            mov dx,SphereHeight                 ;for each row: --
@@NextRow:      mov cx,SphereWidth              ;for each column: --
@@NextColumn:       lodsb
                    or al,al
                    jz @@DontStore
                    push bx
                    xor ah,ah
                    add ax,[cs:MapAngle]
                    cmp ax,MapWidth
                    jb @@AngleOkay
                    sub ax,MapWidth
@@AngleOkay:        add bx,ax
                    mov al,[byte fs:bx]
                    pop bx
                    stosb
                    jmp @@EndColumn
@@DontStore:        inc di
@@EndColumn:    dec cx
                jnz @@NextColumn
                add di,(320-SphereWidth)
                add bx,MapWidth
            dec dx
            jnz @@NextRow

            ret
endp        MapIt
;
