DEFINT A-Z
DECLARE FUNCTION FileExists (FileName$)
DECLARE FUNCTION TestFile (FileName$)
'$INCLUDE: 'QB.BI'

CONST True = -1
CONST False = NOT True

DIM SHARED InReg AS RegType, OutReg AS RegType
DIM SHARED InRegX AS RegTypeX, OutRegX AS RegTypeX
DIM SHARED FileMode
DIM Z1 AS LONG, Z2 AS LONG, X AS LONG, Length AS LONG, HeaderStrt AS LONG, Total AS LONG

'****************
' Program Starts Here
'****************
ON ERROR GOTO TrapError
COLOR 7, 0
Cmd$ = LTRIM$(RTRIM$(UCASE$(COMMAND$)))
IF INSTR(Cmd$, " ") <> 0 THEN
	ZipFile$ = LTRIM$(RTRIM$(LEFT$(Cmd$, INSTR(Cmd$, " ") - 1)))
	BannerFile$ = LTRIM$(RTRIM$(MID$(Cmd$, INSTR(Cmd$, " ") + 1)))
END IF
IF LEN(ZipFile$) = 0 OR LEN(BannerFile$) = 0 THEN
	PRINT
	PRINT "ͻ"
	PRINT " BANNER.EXE v1.0       "
	PRINT "   Inserts a .ZIP file "
	PRINT "   comment into a .ZIP "
	PRINT "   file.               "
	PRINT "ͼ"
	PRINT "Programmed by Jeff Lawson, 1990"
	PRINT
	PRINT "The syntax for BANNER.EXE is:"
	PRINT "     BANNER {ZipFile} {BannerFile}"
	SYSTEM
END IF
FileMode = 1
IF TestFile(ZipFile$) = False THEN
	PRINT "Bad ZipFile name."
	SYSTEM
END IF
FileMode = 2
IF TestFile(BannerFile$) = False THEN
	PRINT "Bad BannerFile name."
	SYSTEM
END IF
IF FileExists(ZipFile$) = False THEN
	PRINT "ZipFile not found."
	SYSTEM
END IF
IF FileExists(BannerFile$) = False THEN
	PRINT "BannerFile not found."
	SYSTEM
END IF

OPEN ZipFile$ FOR BINARY AS #1
OPEN BannerFile$ FOR BINARY AS #2
InStr$ = SPACE$(8): HeaderStrt = 0: InChr$ = CHR$(32)
PRINT "Searching "; ZipFile$; ".  Byte"; : Y = POS(0)
FOR X = LOF(1) TO 1 STEP -1
	GET #1, X, InChr$
	InStr$ = RIGHT$(InStr$ + InChr$, 4)
	IF InStr$ = "KP" THEN
		HeaderStrt = X: PRINT "... Found!"
		EXIT FOR
	END IF
	LOCATE , Y: PRINT X;
NEXT X
IF HeaderStrt = 0 THEN
	PRINT
	PRINT "Not a valid .ZIP file."
	SYSTEM
END IF
InReg.AX = &H5700
InReg.BX = FILEATTR(1, 2)
CALL INTERRUPT(&H21, InReg, OutReg)
ZipFileTime = OutReg.CX
ZipFileDate = OutReg.DX
TempFil$ = ZipFile$ + CHR$(0)
InRegX.AX = &H4300
InRegX.DS = VARSEG(TempFil$)
InRegX.DX = SADD(TempFil$)
CALL INTERRUPTX(&H21, InRegX, OutRegX)
ZipFileAttribs = OutRegX.CX
InRegX.AX = &H4301
InRegX.DS = VARSEG(TempFil$)
InRegX.DX = SADD(TempFil$)
InRegX.CX = 0
CALL INTERRUPTX(&H21, InRegX, OutRegX)
CLOSE
OPEN ZipFile$ FOR BINARY AS #1
OPEN BannerFile$ FOR BINARY AS #2
PRINT "Inserting Banner...  Byte"; : Y = POS(0)
Z1 = HeaderStrt + 22: Z2 = 1: Length = 0: Total = LOF(2) - 1
DO UNTIL Length >= Total
	InChr$ = " "
	LOCATE , Y: PRINT Length; "of"; Total;
	GET #2, Z2, InChr$
	PUT #1, Z1, InChr$
	Z1 = Z1 + 1: Z2 = Z2 + 1
	Length = Length + 1
LOOP
LOCATE , Y: PRINT Total; "of"; Total
CommentSize$ = CHR$(Length MOD 256) + CHR$(Length \ 256)
PUT #1, HeaderStrt + 20, CommentSize$
PRINT "Banner inserted into .ZIP file."
InReg.AX = &H5701
InReg.BX = FILEATTR(1, 2)
InReg.CX = ZipFileTime
InReg.DX = ZipFileDate
CALL INTERRUPT(&H21, InReg, OutReg)
InRegX.AX = &H4301
InRegX.DS = VARSEG(TempFil$)
InRegX.DX = SADD(TempFil$)
InRegX.CX = ZipFileAttribs
CALL INTERRUPTX(&H21, InRegX, OutRegX)
CLOSE
SYSTEM

TrapError:
	SELECT CASE ERR
		CASE 13
			PRINT "Type mismatch (bad filename?)"
		CASE 61
			PRINT "Disk full"
		CASE 62
			PRINT "Input past end of file"
		CASE 67
			PRINT "Too many files"
		CASE 70
			PRINT "Disk write protected"
		CASE 71
			PRINT "Disk not ready"
		CASE 72
			PRINT "Disk not formatted"
		CASE 75
			PRINT "Path/file access error (file Read-only?)"
		CASE ELSE
			PRINT "Error number"; ERR
	END SELECT
	PRINT "Press <ENTER> to try again or <ESC> to abort program"
	DO
		A$ = UCASE$(INKEY$)
	LOOP UNTIL A$ = CHR$(27) OR A$ = CHR$(13) <> 0
	IF A$ = CHR$(27) THEN SYSTEM
	RESUME

FUNCTION FileExists (FileName$)
	Temp$ = FileName$ + CHR$(0)
	InRegX.AX = &H4E00
	InRegX.CX = 7
	InRegX.DS = VARSEG(Temp$)
	InRegX.DX = SADD(Temp$)
	CALL INTERRUPTX(&H21, InRegX, OutRegX)
	FileExists = ((OutRegX.FLAGS AND 1) = 0)
END FUNCTION

FUNCTION TestFile (FileName$)
	FileNme$ = FileName$
	IF MID$(FileNme$, 2, 1) = ":" THEN
		Drive$ = LEFT$(FileNme$, 1)
		FileNme$ = MID$(FileNme$, 3)
		IF ASC(Drive$) > 64 AND ASC(Drive$) < 91 THEN
		ELSE
			TestFile = False
			EXIT FUNCTION
		END IF
		Drive$ = Drive$ + ":"
	END IF
	Path$ = ""
	DO WHILE INSTR(FileNme$, "\")
		Posn = INSTR(FileNme$, "\")
		Path$ = Path$ + LEFT$(FileNme$, Posn)
		FileNme$ = MID$(FileNme$, Posn + 1)
	LOOP
	IF LEN(Path$) > 64 THEN
		TestFile = False
		EXIT FUNCTION
	END IF
	IF INSTR(FileNme$, ".") = 0 THEN
		IF FileMode = 1 THEN
			FileNme$ = FileNme$ + ".ZIP"
		ELSE
			FileNme$ = FileNme$ + "."
		END IF
	END IF
	File$ = LEFT$(LEFT$(FileNme$, INSTR(FileNme$, ".") - 1), 8)
	FileNme$ = MID$(FileNme$, INSTR(FileNme$, ".") + 1)
	Ext$ = LEFT$(FileNme$, 3)
	FileName$ = Drive$ + Path$ + File$ + "." + Ext$
	TestFile = True
END FUNCTION

