#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include "vidlib.h"

/**********************************************************************/
/*                                                                    */
/*  Test: The point, of course, is to thoroughly test functions that  */
/*        weren't tested elsewhere. Total Quality, and all that.      */
/**********************************************************************/

void main(void)
{
   int temp,i;

   printf("\n\nLow level function test for VIDLIB v%s\n\n", VIDLIB_VERSION);
   /************************************************************/
   printf("Exercising MO register functions.\n"
          "Your screen may temporarily lose sync. Don't be alarmed.\n");

   temp=MOread_reg();
   printf("MOread_reg()=%02x\n", temp);
   getch();
   MOset_regm(0x04,0x02);   /* disable display ram access */
   printf("This line should NOT be displayed.\n");
   getch();
   MOset_reg(temp);
   getch();
   printf("If the last printed line reads 'MOread_reg() ...', then"
          " MOset_regm() passes.\n");
   printf("MOset_reg(%02x)=%02x\n", temp, MOread_reg());
   if ( MOread_reg() == temp )
      printf("MOread_reg() and MOset_reg() pass.\n");
   else
      printf("MOread_reg() and/or MOset_reg() fail.\n");
   getch();

   /************************************************************/
   printf("Waiting for vertical retrace.\n");
   Vwait_vretrace();
   printf("Waiting again for vertical retrace.\n");
   Vwait_vretrace();
   printf("Waiting for horizontal retrace.\n");
   Vwait_hretrace();
   printf("Waiting again for horizontal retrace.\n");
   Vwait_hretrace();

   /************************************************************/
   printf("\nExercising CRTC register functions.\n");

   CRTCset_reg(0x0d, 0x50);
   if ( CRTCread_reg(0x0d) != 0x50)
      printf("first set/read failed.\n");
   else
      printf("first set/read succeeded. Should've dropped 1 line.\n");
   getch();
   CRTCset_regm(0x0d, 0xf0, 0xaf);
   if ( CRTCread_reg(0x0d) != 0xf0)
      printf("second set/read failed.\n");
   else
      printf("second set/read succeeded. Should've dropped 2 more lines.\n");
   getch();
   CRTCset_reg(0x0d,0);
   printf("Should've regained all lost lines.\n");
   getch();

   /************************************************************/
   printf("\nExercising GC register functions.\n");

   printf("GCread_reg(1)=%02x.\n", GCread_reg(1)); /* clock mode register */
   temp=GCread_reg(2); /* plane enable register */
   GCset_reg(2, 0x02);
   if ( GCread_reg(2) == 0x02 )
      printf("GCread_reg() and GCset_reg() pass.\n");
   else
      printf("GCread_reg() and/or GCset_reg() fail.\n");
   GCset_regm(2, 0x0f, 0x01);
   if ( GCread_reg(2) == 0x03 )
      printf("GCset_regm() passes.\n");
   else
      printf("GCset_regm() fails, reg(2)=%02x.\n", GCread_reg(2));
   GCset_reg(2, temp);
   getch();

   /************************************************************/
   printf("\nExercising AC register functions.\n");
   temp=ACread_reg(0x12); /* color plane enable register
                             caveat: bits 4-7 are status bits which can
                             change at any time */
   ACset_reg(0x12, 0x04);
   if ( (ACread_reg(0x12) & 0x0f) == 0x04 )
      printf("ACread_reg() and ACset_reg() pass.\n");
   else
      printf("ACread_reg() and/or ACset_reg() fail, reg(0x12)=%02x.\n",
                           ACread_reg(0x12));
   getch();
   ACset_regm(0x12, 0x0f, 0x01);
   if ( (ACread_reg(0x12) & 0x0f) == 0x05 )
      printf("ACset_regm() passes.\n");
   else
      printf("ACset_regm() fails, reg(0x12)=%02x.\n",
                           ACread_reg(0x12));
   getch();
   ACset_reg(0x12, temp);
   printf("Testing horizontal panning with vertical retrace timing.\n");
   for (i=0; i<2000; i++) {
      Vwait_vretrace();
      if ( i%9 == 0 ) {
         CRTCset_reg(0x0d, CRTCread_reg(0x0d)+1);
      }
      ACset_regm(0x13, (i%9)-1 , 0x0f);
      if (kbhit()) {
         getch();
         break;
      }
   }
   ACset_reg(0x13,0xff);
   CRTCset_reg(0x0d,0);


   printf("\n\nTesting completed.\n\n");
   exit(0);
}