
;
;   This code was written by Draeden of VLA on June 28, 1993.
;
    
Active_Keys db  128 dup (0) ;correspond to the 127 possible key codes
                            ; 0 means it's not pressed, nonzero, it is
Key_Pressed db  ?           ;says a key was pressed.. user must zero out..
ESC_Pressed db  ?           ;flag that says that the ESC key is pressed
Last_Pressed db ?           ;scan code of last key pressed

    
    ;   This routine will wait until the keyboard's status port
    ;   says it is ready..
    
PROC KB_Wait  NEAR
    xor     cx,cx
@@Wait_KB:
    in      al,64h              ;keep on polling the status port until
    test    al,2                ; the key is done coding...
    loopnz  @@Wait_KB
    ret
ENDP

    
    ;   A keyboard interrupt (irq 1, int 9) that replaces the old int 9
    ;   This does not buffer keys or anything.. meant to be used in a
    ;   game/demo type setting where you are only concerned with what
    ;   keys are currently being pressed.
    ;
    ;   Limitations (of the hardware):
    ;      cannot distinguish between right and left CTRL & ALT keys
    ;      cannot distinguish between grey keys and non-grey keys
    ;       I could, but that would take a little work... The grey keys 
    ;       send a scan code that is the same as the LEFT SHIFT key and 
    ;       then send the same scan code as the normal key
    ;      because of the above problem, the LEFT SHIFT key may stay on
    ;       even though it's not being pressed- don't rely on that key...
    ;       BUT, the 2ah will not be sent first if Num-Lock is OFF
    ;
    ; Variables:
    ;
    ;   Last_Pressed - holds the scan code of the last key serviced
    ;                   whether it was turned on or off
    ;   Key_Pressed  - contains a 1 if there has been a keypress since
    ;                   the last time the user cleared this variable
    ;   ESC_pressed  - 1 if ESC key is down, 0 if it's not
    ;
    ;   Active_Keys  - an array of 128 bytes, each representing the scan
    ;                   code of a key. If that key is down that byte will
    ;                   be a 1, if not, it will be a 0.
    
PROC Int_09 FAR
    push    ax bx cx

    cli                         ;make sure no interrupts interrupt us =)
    call    KB_Wait
    in      al,60h              ;Grab the key...
    sti                         ;allow interrupts again

    mov     ah,1                ;assume we are turning a key on
    or      al,al               ;if the high bit is set, it's a release code 
    jns     @@Off_Code
    xor     ah,ah
@@Off_Code:
    and     al,01111111b                ;mask out top bit
    movzx   bx,al                       ;use scan code as index
    mov     [cs:Active_Keys + bx],ah    ;move in a 0 or 1
    or      [cs:Key_Pressed],ah         ;update Key_Pressed

    mov     [cs:Last_Pressed],al        ;update last_pressed

    dec     al                  ;was it the ESC key? (scan code = 1)
    jne     @@Not_ESC
    mov     [cs:ESC_Pressed],ah ;update ESC_Pressed
@@Not_ESC:

    mov     al,20h
    out     20h,al
    pop     cx bx ax
    iret
ENDP

    
    ;   bx = interrupt # to replace                                    
    ;cs:si = address of where to store old interrupt vector            
    ;  eax = address of new interrupt (segment high, offset low)       
    
PROC Install_Int
    push    ds cx bx eax
                  
    xor     cx,cx
    mov     ds,cx
    shl     bx,2

    cli
    xchg    [ds:bx],eax
    sti
    mov     [cs:si],eax

    pop     eax bx cx ds
    ret
ENDP

    
    ;   bx = interrupt # to restore
    ;cs:si = address of where old interrupt vector was stored
    
PROC Restore_Int
    push    ds ecx bx

    xor     cx,cx
    mov     ds,cx
    shl     bx,2

    mov     ecx,[cs:si]
    cli
    mov     [ds:bx],ecx
    sti
    
    pop     bx ecx ds
    ret
ENDP

    
    ; sets all the cute little KB lights to whats in BL
    
PROC setkb NEAR
    push    ax
    mov     al,0edh
    call    Send_KB
    mov     al,bl
    call    Send_KB
    mov     al,0f4h
    call    Send_KB
    pop     ax
    ret
ENDP

    
    ;   Sends a command to the KB
    
PROC Send_KB NEAR
    push    ax bx cx

    mov     ah,al
    mov     bh,3

@@Loop_0:
    call    KB_Wait
    mov     al,ah
    out     60h,al
    
    mov     cx,4000

@@Loop_1:
    in      al,61h
    test    al,10h
    jz      @@Loop_1

@@Loop_2:
    in      al,61h
    test    al,10h
    jnz     @@Loop_2

    in      al,64h
    test    al,1
    loopz   @@Loop_1

    in      al,60h
    cmp     al,0fah
    je      @@Done

    dec     bh
    jnz     @@Loop_0
@@Done:

    pop     cx bx ax
    ret
ENDP
