// TIMER_C //////////////////////////////////////////////////////////////////

// Methods implementing a high speed timer

// INCLUDES /////////////////////////////////////////////////////////////////

#include <dos.h>
#include "timer.h"

// CONSTRUCTOR

timer_C::timer_C()
{
  outportb(0x43,0x34);
  outportb(0x40,0x00);
  outportb(0x40,0x00);
}

// DESTRUCTOR

timer_C::~timer_C()
{
  outportb(0x43,0x36);
  outportb(0x40,0x00);
  outportb(0x40,0x00);
}

// READTIMER

// Reads the timer with millisecond precision

long timer_C::readtimer(void)
{
  asm push si
  asm push di

  asm cli
  asm mov dx,0x0020
  asm mov al,0x0a
  asm out dx,al
  asm xor al,al
  asm out 0x43,al
  asm in al,dx
  asm mov di,ax
  asm in  al,0x40
  asm mov bl,al
  asm in  al,0x40
  asm mov bh,al
  asm not bx
  asm in  al,0x21
  asm mov si,ax

  asm mov al,0xff
  asm out 0x21,al
  asm mov ax,0x0040
  asm mov es,ax
  asm mov dx,es:[0x006c]

  asm mov ax,si
  asm out 0x21,al

  asm sti
  asm mov ax,di
  asm test al,0x01
  asm jz done
  asm cmp bx,0x00ff
  asm ja done
  asm inc dx
done:
  asm mov ax,bx
  asm pop di
  asm pop si
}

// ELAPSED

// Computes the elapsed time, in milliseconds, between two events.

long timer_C::elapsed(unsigned long start,unsigned long stop)
{
  return (stop-start)/(long)1193;
}

