        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include low_data.inc
include low_none.inc
include low_gus.inc
include low_sb.inc
include mtmplay.inc
include argc.inc
include kb.inc
include v.inc

public  _muz_init, _muz_play, _muz_stop, _muz_uninit, _muz_setup, _muz_wait

;
; DATA
;
align 4
scard_datatbl   dd      _none_data, _sb_data, _gus_data
scard_irqmsgtbl dd      msgdat2, msgdat3
scard_ratetbl   dw      11025, 22050, 44100

scard_data      dd      ?
scard_rate      dw      ?

scard_switch    db      0
scard_info      db      ?,?,?,?

scard_irqtbl    db      3,5,7
                db      2,3,5,7,11,12,15

muzik           label   byte
include muzik.m

crlf2str        db      0dh,0ah,0dh,0ah,36
msgend          db      'You can skip the initial souncard menu, and run this demo with the same',0dh,0ah
                db      'soundcard options, by using the ''/S'' switch on the commandline as follows:',0dh,0ah
msgendmodify    db      '  TIMELESS /S    ',0dh,0ah,0dh,0ah,36
msgdef          db      'ESC) Abort',0dh,0ah,'> $'
msgdat0         db      '3'
                db      'Select soundcard:',0dh,0ah
                db      '1) None',0dh,0ah
                db      '2) Sound Blaster',0dh,0ah
                db      '3) Gravis Ultrasound',0dh,0ah,36
msgdat1         db      '6'
                db      'Select port address:',0dh,0ah
                db      '1) 210',0dh,0ah
                db      '2) 220',0dh,0ah
                db      '3) 230',0dh,0ah
                db      '4) 240',0dh,0ah
                db      '5) 250',0dh,0ah
                db      '6) 260',0dh,0ah,36
msgdat2         db      '3'
                db      'Select IRQ:',0dh,0ah
                db      '1) 3',0dh,0ah
                db      '2) 5',0dh,0ah
                db      '3) 7',0dh,0ah,36
msgdat3         db      '7'
                db      'Select IRQ:',0dh,0ah
                db      '1) 2',0dh,0ah
                db      '2) 3',0dh,0ah
                db      '3) 5',0dh,0ah
                db      '4) 7',0dh,0ah
                db      '5) 11',0dh,0ah
                db      '6) 12',0dh,0ah
                db      '7) 15',0dh,0ah,36
msgdat4         db      '3'
                db      'Select mixing rate:',0dh,0ah
                db      '1) 11025',0dh,0ah
                db      '2) 22050',0dh,0ah
                db      '3) 44100',0dh,0ah,36

;
; CODE
;

;
; Set up muzik player (get soundcard type)
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_setup:
        mov al,'s'
        call _cchekswitch
        jnc short setupf1
        mov al,'S'
        call _cchekswitch
        jc short setupf2
setupf1:
        mov edx,_lomembase
        call _ccheksstr
        jc short setupf2
        mov eax,[edx]
        sub eax,'1111'
        or al,al
        jz short setupf3
        cmp ah,5
        ja short setupf2
        shld ebx,eax,16
        cmp al,2
        ja short setupf2
        je short setupf4
        cmp bl,2
        ja short setupf2
        cmp bh,2
        ja short setupf2
        jmp short setupf3
setupf4:
        cmp bl,6
        ja short setupf2
setupf3:
        mov dword ptr scard_info,eax
        mov scard_switch,1
        jmp short setupf0

setupf2:
        mov edi,offset scard_info
        mov esi,offset msgdat0
        call setupr0
        or al,al
        jz short setupf0
        mov esi,offset msgdat1
        call setupr0
        movzx ebx,scard_info[0]
        mov esi,scard_irqmsgtbl[ebx*4-4]
        call setupr0
        cmp bl,1
        jne short setupf0
        mov esi,offset msgdat4
        call setupr0

setupf0:
        mov edi,offset msgendmodify+13
        mov esi,offset scard_info
        xor eax,eax
        lodsb
        lea edx,[eax*2+eax-3]
        mov ebx,scard_datatbl[eax*4]
        mov scard_data,ebx
        add al,'1'
        stosb
        cmp al,'1'
        je _ret
        lodsb
        lea ebx,[eax+21h]
        shl ebx,4
        mov _low_port,bx
        add al,'1'
        stosb
        lodsb
        mov bl,scard_irqtbl[edx+eax]
        mov _low_irq,bl
        add al,'1'
        stosb
        or dl,dl
        jnz _ret
        lodsb
        mov bx,scard_ratetbl[eax*2]
        mov scard_rate,bx
        add al,'1'
        stosb
        ret
;-----------------------------------------------------------------------------
setupr0:
        lea edx,[esi+1]
        call _putdosmsg
        mov edx,offset msgdef
        call _putdosmsg
setupr0l0:
        mov v86r_ah,0
        mov al,16h
        int 33h
        mov al,v86r_al
        cmp al,27
        je _exit
        cmp al,'1'
        jb setupr0l0
        cmp al,[esi]
        ja setupr0l0
        call _putdoschar
        sub al,'1'
        stosb
        mov edx,offset crlf2str
        call _putdosmsg
        ret

;
; Init muzik player
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_init:
        mov _mtm_voicenum,8
        mov esi,scard_data
        mov bx,scard_rate
        mov ah,8
        call _mtmp_init
        ret

;
; Kill muzik player
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_uninit:
        cmp scard_switch,0
        jne short uninitf0
        mov edx,offset msgend
        call _putdosmsg
uninitf0:
        call _mtmp_uninit
        ret

;
; Start muzik playing
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_play:
        mov edx,offset muzik
        call _mtmp_setmuz
        call _mtmp_playmuz
        ret

;
; Stop muzik playback (set it to phade out)
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_stop:
        mov al,2
        call _mtmp_phademuz
        ret

;
; Wait for muzik to finish fading out
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_muz_wait:
        cmp scard_info[0],0
        je _ret
waitl0:
        cmp _mtm_playing,0
        jne waitl0
        ret

code32  ends
        end

