MASM

COMMENT $


                                  MOUSE.ASM    
                                  

    Well, here it is, Lithium's first tutorial!  This was the first program
I wrote in assembly language, so it holds a special place in my heart.
Basicly, programming for the mouse is pretty easy.  Using BIOS int 33h,
there are many, many different functions at your disposal.  My book lists
52 at mouse driver 8.0  Unfortunately, my book doesn't document the registers
on return from these functions.  This was written with info from a C book,
but readily applies to the ASM world.  The functions used in this program
will get you all the information you should need to get started with little
programs using the mouse.  So, although I don't feel like exploring the
world of the mouse, you can see what info you get back from these functions


Function            Driver          Purpose

 
 0                                  Reset/Initialize Mouse               
 1                                  Show Mouse Cursor
 2                                  Hide Mouse Cursor
 3                                  Get Mouse Status
 4                                  Set cursor position
 5                                  Get button press info
 6                                  Get button release info
 7                                  Set horizontal boundaries
 8                                  Set vertical boundaries
 9                                  Set graphics cursor block
10                                  Set text cursor
11                                  Read motion counters
12                                  Set interrupt subroutine
13                                  Enable light-pen emulation
14                                  Disable light-pen emulation
15                                  Set mickey-to-pixel ratio
16                                  Conditional off

17 and 18 are not listed

19                                  Set double-spedd threshold
20                                  Swap interrupt subroutines
21                                  Get mouse driver state storage needs
22                                  Save mouse driver state
23                                  Restore mouse driver state
24                                  Set alternate subroutine
25                                  Get alternate interrupt address
26                                  Set mouse sensitivity
27                                  Get mouse sensitivity
28                                  Set interrupt rate
29                                  Set CRT page number
30                                  Get CRT page number
31                                  Disable mouse driver
32                                  Enable mouse driver
33                                  Software reset
34                                  Set language for messages 
                                    (international versions only)
35                                  Get language (same restriction)
36                                  Get driver version info
37                  6.26            Get general driver info
38                  6.26            Get maximum virtual coordinates
39                  7.01            Get cursor masks and mickey counts
40                  7.0             Set video mode
41                  7.0             Get supported video modes
42                  7.02            Get cursor hot spot
43                  7.0             Set acceleration curves
44                  7.0             Get acceleration curves
45                  7.0             Set or get active acceleration curve

46 is not listed

47                  7.02            Mouse hardware reset
48                  7.04            Set or get BallPoint information
49                  7.05            Get virtual coordinates
50                  7.05            Get active advanced functions
51                  7.05            Get switch settings
52                  8.0             Get MOUSE.INI


After typing all that out, I think I could have written my little program
in just a couple of lines.  Oh well, it's the adventure of programming that
brings the rewards...  

Lithium /VLA


$    

    IDEAL
    DOSSEG
    MODEL SMALL
    STACK 200h
    p286
    ASSUME CS:@CODE 
        ;above line is for the compiler only- it creates no code



CodeSeg


Message     db  "Mouse driver not present$"

Ypos        dw  100     ; Starting Y position
Xpos        dw  160     ; Starting X position

OldY        dw  ?
OldX        dw  ?

Yvel        dw  1
Color       db  50h     



XMin        =   0       ; We are using a 320x200 screen
XMax        =   318     ; The dot used for the pointer is
YMin        =   0       ; 2x2 pixels, so these are the screen
YMax        =   198     ; boundries



; Subroutines ;


    
    ; PROC SetMouse
    ;
    ; Calls the BIOS mouse int, function 0
    ; This will determin if a mouse is present
    ;
    ; Will return AX == 0 if mouse exists
    ;             AX <> 0 if not there
    
PROC SetMouse
    mov     ax,0
    int     33h
    inc     ax
    ret         ;ax=0 successful, ax!=0 no mouse found
ENDP SetMouse


    
    ; PROC CheckMouse
    ;
    ; Will read the mouse position and place it 
    ; into [Xpos] and [Ypos], it checks for boundries
    ; using XMin, XMax, YMin, and YMax
    ;
    ; Old X and Y are stored in [OldX] and [OldY]
    ;
    ; If Right button pressed, [Color] = 50h
    ; If Left  button pressed, [Color] = 20h
    ;
    ; No Registers Effected
    

PROC CheckMouse
    pusha

    mov     ax,[Xpos]       ; Save the old X and Y 
    mov     [OldX],ax
    mov     ax,[Ypos]
    mov     [OldY],ax

    mov     ax,11
    int     33h             ; Bios int 33h function 0Bh
    add     [Xpos],cx       ; returns X position in CX
    add     [Ypos],dx       ;         Y position in DX
    
    cmp     [Xpos],XMin
    jge     @@XNotToSmall   ; Don't let it go off the left side of 
                            ; of the screen
    mov     [Xpos],XMin

@@XNotToSmall:
    cmp     [Xpos],XMax     ; Same deal with the rest of these jumps
    jle     @@XNotToBig     ; we check the position against the boundry
                            ; values and set them equal if they are 
    mov     [Xpos],XMax     ; beyond

@@XNotToBig:
    cmp     [Ypos],YMin
    jge     @@YNotToSmall
    
    mov     [Ypos],YMin

@@YNotToSmall:
    cmp     [Ypos],YMax
    jle     @@YNotToBig
    
    mov     [ypos],YMax

@@YNotToBig:                ; So our mouse is in bounds now

    mov     ax,3            ; Bios int 33h function 3 checks the
    int     33h             ; mouse status, so we can get the
                            ; state of the buttons
    shr     bx,1
    jnc     @@RightNotPushed
    
    mov     [Color],50h

@@RightNotPushed:
    shr     bx,1
    jnc     @@LeftNotPushed
    
    mov     [Color],20h

@@LeftNotPushed:
    popa
    ret
ENDP CheckMouse


    
    ; PROC DrawDot
    ;
    ; Draws a 2x2 dot of [Color] in the X and Y
    ; position of [Xpos] and [Ypos]
    ;   
    ; Also deletes the old dot, using [OldX] and [OldY]
    ;
    ; No Registers Effected
    
PROC DrawDot
    pusha

    mov     di,[OldY]       ;We will use the old X and Y to find
    imul    di,320          ;Where to erase the 2x2 dot
    add     di,[OldX]
    mov     ax,0
    stosw
    add     di,318
    stosw
    
    mov     di,[Ypos]       ;We can use the same method of our madness
    imul    di,320          ;to get the position on the screen to
    add     di,[Xpos]       ;draw the new dot 2x2
    mov     al,[Color]
    mov     ah,al
    stosw
    add     di,318
    stosw

    popa  
    ret
ENDP DrawDot 



; Code ;

Start:
    mov     ax,cs       ;move CS to AX
    mov     ds,ax       ;move AX to DS   
                        ;this is needed because DOSFN 09h requires
                        ;DS:DX to point to the start of the data to 
                        ;be display
    
    mov     ax,0a000h   ; 0a000:0000 is the start of the VGA screen
    mov     es,ax       ; We would like ES to hold that for us
    
    call    SetMouse    ; Do we have a mouse?
    or      ax,ax
    jz      @@Foundmouse
    
    mov     dx,offset Message
    mov     ah,9            
    int     21h         ; Must not if we got here, so print the
    jmp     @@Bye       ; Error message before exiting

@@FoundMouse:
    mov     ax,0013h    ;ah=00h al=13h Funct 00h = set video mode (al)
    int     10h         ;Bios Video Interrupt
    
@@MainLoop:
    mov     dx,03dah    ;Port that is read from
@@vr1:                  ;when verticle retrace occurs bit 4 is set
    in      al,dx       ;and the loop will cease
    and     al,00001000b
    jz      @@vr1       ;jump if zero flag is set

    call    DrawDot
    call    CheckMouse
    
    mov     ah,1        ; We'll check for a key press
    int     16h         
    jz      @@MainLoop  ; A key will be the exit condition
    
    mov     ah,0        ; We need to grab that key, so it
    int     16h         ; doesn't show up at the prompt
    
@@Bye:
    mov     ax,0003h    ;ah=0, al=3 80x25x16 text
    int     10h         ;Bios interrupt

    mov     ax,4c00h    ;DOS funtion 4ch - terminate program
    int     21h         ;Standard DOS services interrupt
                        ;For DOS int calls ah= function #
END Start

