/* demonstration Beholder Application */


#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/APS/GEN/VCS/DPAGEN.C_V   1.0   08 Nov 1990 15:20:38   etstjan  $";
#endif
#include <stdio.h>                          /* for NULL */
#include <dp.h>                             /* for DP... definitions        */
#include <power3.h>                         /* for POWER screen functions   */
#INCLUDE <ml.h>                             /* for ML-functions             */

/* prototyping of static functions                                          */
static int  ProcessEvent(DPEVENT Event);    /* Event processing function    */
static void ReceivePkt  (void);             /* Event functions ...          */
static void EverySecond (void);
static int  Init        (void);
static void End         (void);
static int  Start       (void);
static void Stop        (void);
static void Reset       (void);
static void Show        (void);
static void Hide        (void);
static void FreeTime    (void);

static PWWIN *pWin;                         /* Application window pointer   */
static long  Seconds;
static long  Packets;
static long  Bytes;

DPAPPS DpaGen = {
    "Generic",                              /* Application name             */
    ProcessEvent,                           /* Event processing function    */
    0,                                      /* Status, must be 0            */
                /* DPE_DEFAULT = DPE_INIT | DPE_END | DPE_START | DPE_STOP  */
    DPE_DEFAULT | DPE_RESET | DPE_FREETIME | /* Event mask                  */
            DPE_EVERYSECOND | DPE_RECEIVEPKT,
    DPE_RESET | DPE_START | DPE_SHOW,        /* Event start mask            */
    DPE_RESET,                               /* Timer mask                  */
    10000,                                   /* Timer value (msec)          */
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};

/* ************************************************************************ **
** The dispatcher dispathes events to applications by calling this function
** This function must perform the requested actions, depending on the
**   specified event type in the first parameter 'Event'.
** ************************************************************************ */
static int ProcessEvent(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
    case DPE_RECEIVEPKT:    ReceivePkt();   break;
    case DPE_EVERYSECOND:   EverySecond();  break;
    case DPE_INIT:    ret = Init();         break;
    case DPE_END:           End();          break;
    case DPE_START:   ret = Start();        break;
    case DPE_STOP:          Stop();         break;
    case DPE_SHOW:          Show();         break;
    case DPE_HIDE:          Hide();         break;
    case DPE_RESET:         Reset();        break;
    case DPE_FREETIME:      FreeTime();     break;
    }
    return ret;
}

static void ReceivePkt(void)
{
    DPBUF *pBuf = DpReceivePkt();               /* get packet descriptor */

    Packets++;                              /* increase packet count */
    Bytes += pBuf->Size;                    /* update byte count */
}

/*****************************************************************
** NAME:        
** SYNOPSIS:    
** RELATED TO:  
** DESCRIPTION: 
** REMARKS:     This EVERYSECOND event is generated by the dispatcher
**              every second DURING INTERRUPT TIME.
**                This means that NO functions are allowed, which result in:
**              - A call to a function with stack checking (eg. printf).
**              - A call to a DOS interrupt (eg. file I/O). 
** RETURN TYPE: 
** EXIT STATUS: 
*****************************************************************/

static void EverySecond(void)
{
    Seconds++;                              /* increase second counter */
}

static int  Init(void)
{
    int ret = 0;

    /* usually used for array allocation, using malloc() */
    return ret;
}

static void End(void)
{
    /* usually used for freeing arrays, using free() */
}

static int  Start(void)
{
    int ret = 0;

    pWin = pw_open(4, 25, 7, 22, "Generic", PWM_DEFAULT, PWW_NORMAL);
        /* open a window at row=4,col=25, height=3,width=20 */
        /* with the header 'Generic Count' */
        /* at level -1 (Elapsed time=lev 0, for the bottom key info line) */
        /* of window type HELP */
    pw_shade(pWin);                         /* Add a shade to this window */
    pw_putsat(pWin, 0, 1, "Packets:");
    pw_putsat(pWin, 1, 1, "Bytes:");
    pw_putsat(pWin, 2, 1, "Seconds:");
    pw_putsat(pWin, 3, 1, "Start:");
    pw_putsat(pWin, 4, 1, "Stop:");
    pw_putsat(pWin, 5, 1, "Timer:");
    pw_putsat(pWin, 6, 1, "Now:");
    return ret;
}

static void Stop(void)
{
    pw_close(pWin);
}

static void Reset(void)
{
    Packets = 0L;
    Bytes   = 0L;
    Seconds = 0L;
}

static void Show(void)
{
    pw_show(pWin);
}

static void Hide(void)
{
    pw_hide(pWin);
}

extern DPDEV DpDevActive[DPMAXDEV];
static void FreeTime(void)
{
    if (DpaGen.Status & DPE_SHOW)           /* is application visible ? */
    {
        pw_printfat(pWin, 0, 10, "%10lu", Packets);
        pw_printfat(pWin, 1, 10, "%10lu", Bytes);
        pw_printfat(pWin, 2, 10, "%10lu", Seconds);
        pw_printfat(pWin, 3, 10, "%10lu", DpaGen.TimerStart);
        pw_printfat(pWin, 4, 10, "%10lu", DpaGen.TimerStop);
        pw_printfat(pWin, 5, 10, "%10lu", DpaGen.Timer);
        pw_printfat(pWin, 6, 10, "%10lu", DpAppsGetTimer(0));
    }
}

