/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPTYPE.C
**     SYSTEM   NAME:       PACKET DISPATCHER       
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1991/3/4
**
** DESCRIPTION: Dispatcher's type filter controll functions
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif

#include <stdlib.h>
#include "dp.h"



DPTYPEFILT DptAll =  {"All", 0, ""};
DPTYPEFILT DptIP =   {"IP", 2, "\x08\x00"};
DPTYPEFILT DptArp =   {"Arp", 2, "\x08\x06"};
DPTYPEFILT DptRarp =   {"Rarp", 2, "\x08\x35"};

int DpTypeFiltCount;

int DpTypeFiltInit (void)
{
    for (DpTypeFiltCount=0; DpTypeFiltAvailable[DpTypeFiltCount]; DpTypeFiltCount++);
    return (0);
}

void DpTypeFiltEnd (void)
{
    DpTypeFiltCount = 0;
}

int DpTypeFiltGetCount (void)
{
    return (DpTypeFiltCount);
}

char *DpTypeFiltGetName (int Filt)
{
    if (Filt<0 || Filt>=DpTypeFiltCount)
        return (NULL);
    return (DpTypeFiltAvailable[Filt]->Name);
}

int DpTypeFiltGetLength (int Filt)
{
    if (Filt<0 || Filt>=DpTypeFiltCount)
        return (-1);
    return (DpTypeFiltAvailable[Filt]->TypeLen);
}

char *DpTypeFiltGetData (int Filt)
{
    if (Filt<0 || Filt>=DpTypeFiltCount)
        return (NULL);
    return (DpTypeFiltAvailable[Filt]->TypeData);
}
