/****************************************************************************
** File:     POWER3.H
** Subject:  Definitions and function declarations for POWER v3.20
** Author:   Ling Thio Software Productions
** Date:     October 1991
****************************************************************************/

#ifndef PWKEY

/****************************************************************************
** Window type definitions (wtype).
**     Used by: pw_open(), pw_question(), pw_attrib().
****************************************************************************/
#define PWW_INIT        0
#define PWW_NORMAL      1
#define PWW_HEADER      2
#define PWW_KEYINFO     3
#define PWW_MENU        4
#define PWW_DATA        5
#define PWW_ERROR       6
#define PWW_HELP        7
#define PWW_SPECIAL     8

/****************************************************************************
** Window mode definitions (wtype).
**     Used by: pw_open().
****************************************************************************/
#define PWM_DEFAULT     0x000
#define PWM_NOBORDER    0x010
#define PWM_NOSHADE     0x020
#define PWM_HIDE        0x040
#define PWM_PUSH        0x080
#define PWM_NOHEADER    0x100
#define PWM_NOKEYINFO   0x200

/****************************************************************************
** Text type definitions (ttype).
**     Used by: pw_block(), pws_attrib().
****************************************************************************/
#define PWT_NORMAL       0
#define PWT_HIGHLIGHT    1
#define PWT_REVERSE      2
#define PWT_SPECIAL      3
#define PWT_ACTIVEBORDER 4
#define PWT_BORDER       5

/****************************************************************************
** Input mode definitions (mode).
**     Used by: pw_input).
****************************************************************************/
#define PWM_EMPTY       1
#define PWM_DISPLAY     2
#define PWM_PROMPT      3
#define PWM_UEMPTY      5
#define PWM_UDISPLAY    6
#define PWM_UPROMPT     7

/****************************************************************************
** Action types definitions (action).
**     Used by process functions of: pw_select().
****************************************************************************/
#define PWA_INIT        1
#define PWA_COUNT       2
#define PWA_DISPLAY     3
#define PWA_ENTER       4
#define PWA_INSERT      5
#define PWA_DELETE      6
#define PWA_KEY         7
#define PWA_FIRSTCHAR   8

/****************************************************************************
** Return codes for menu functions
**     Used by process functions of: pw_menu().
****************************************************************************/
#define PWA_EXITMENU    (-1)
#define PWA_UPDATELINE  (-2)
#define PWA_UPDATEMENU  (-3)

/****************************************************************************
** Return codes for progam exit functions
****************************************************************************/
#define PWR_QUIT        (-1)
#define PWR_CONTINUE    (0)

/****************************************************************************
** Special pw_open() top-left and size parameters.
**   srow: PWC_TOP,    PWC_CENTER(nrow), PWC_BOTTOM(nrow must be set).
**   scol: PWC_LEFT,   PWC_CENTER(ncol), PWC_RIGHT (ncol must be set).
**   nrow: PWC_BOTTOM, PWC_CENTER(srow must be set).
**   ncol: PWC_RIGHT,  PWC_CENTER(scol must be set).
** Special pw_menu() size parameters.
**   nrow: PWC_AUTO
**   ncol: PWC_AUTO
****************************************************************************/
#define PWC_AUTO        (0)
#define PWC_LEFT        (-1)
#define PWC_TOP         (-1)
#define PWC_CENTER      (-2)
#define PWC_RIGHT       (-3)
#define PWC_BOTTOM      (-3)

/****************************************************************************
** Window id definitions (id).
**     Used by the function: pw_win().
****************************************************************************/
#define PWID_TOP        1
#define PWID_BACKGROUND 2
#define PWID_ACTIVE     3

/****************************************************************************
** Special keycode definitions (PWKEY).
**     Returned by functions: pw_getkey().
**     All keycodes are of type PWKEY (unsigned int).
**     Printable keycodes are treated normally:
**       eg 'A'-'Z', 'a'-'z', '0'-'9', '!", '@', '#', ... etc.
****************************************************************************/
#define PWK_BACKSPACE   8
#define PWK_TAB         9
#define PWK_CENTER      10
#define PWK_ENTER       13
#define PWK_ESC         27
#define PWK_SPACE       32
#define PWK_STAB        0x0f00
#define PWK_ALT_Q       0x1000
#define PWK_ALT_W       0x1100
#define PWK_ALT_E       0x1200
#define PWK_ALT_R       0x1300
#define PWK_ALT_T       0x1400
#define PWK_ALT_Y       0x1500
#define PWK_ALT_U       0x1600
#define PWK_ALT_I       0x1700
#define PWK_ALT_O       0x1800
#define PWK_ALT_P       0x1900
#define PWK_ALT_A       0x1E00
#define PWK_ALT_S       0x1F00
#define PWK_ALT_D       0x2000
#define PWK_ALT_F       0x2100
#define PWK_ALT_G       0x2200
#define PWK_ALT_H       0x2300
#define PWK_ALT_J       0x2400
#define PWK_ALT_K       0x2500
#define PWK_ALT_L       0x2600
#define PWK_ALT_Z       0x2C00
#define PWK_ALT_X       0x2D00
#define PWK_ALT_C       0x2E00
#define PWK_ALT_V       0x2F00
#define PWK_ALT_B       0x3000
#define PWK_ALT_N       0x3100
#define PWK_ALT_M       0x3200
#define PWK_F1          0x3B00
#define PWK_F2          0x3C00
#define PWK_F3          0x3D00
#define PWK_F4          0x3E00
#define PWK_F5          0x3F00
#define PWK_F6          0x4000
#define PWK_F7          0x4100
#define PWK_F8          0x4200
#define PWK_F9          0x4300
#define PWK_F10         0x4400
#define PWK_HOME        0x4700
#define PWK_UP          0x4800
#define PWK_PGUP        0x4900
#define PWK_LEFT        0x4B00
#define PWK_RIGHT       0x4D00
#define PWK_END         0x4F00
#define PWK_DOWN        0x5000
#define PWK_PGDN        0x5100
#define PWK_INSERT      0x5200
#define PWK_DEL         0x5300
#define PWK_SF1         0x5400
#define PWK_SF2         0x5500
#define PWK_SF3         0x5600
#define PWK_SF4         0x5700
#define PWK_SF5         0x5800
#define PWK_SF6         0x5900
#define PWK_SF7         0x5A00
#define PWK_SF8         0x5B00
#define PWK_SF9         0x5C00
#define PWK_SF10        0x5D00
#define PWK_CF1         0x5E00
#define PWK_CF2         0x5F00
#define PWK_CF3         0x6000
#define PWK_CF4         0x6100
#define PWK_CF5         0x6200
#define PWK_CF6         0x6300
#define PWK_CF7         0x6400
#define PWK_CF8         0x6500
#define PWK_CF9         0x6600
#define PWK_CF10        0x6700
#define PWK_ALT_F1      0x6800
#define PWK_ALT_F2      0x6900
#define PWK_ALT_F3      0x6A00
#define PWK_ALT_F4      0x6B00
#define PWK_ALT_F5      0x6C00
#define PWK_ALT_F6      0x6D00
#define PWK_ALT_F7      0x6E00
#define PWK_ALT_F8      0x6F00
#define PWK_ALT_F9      0x7000
#define PWK_ALT_F10     0x7100
#define PWK_CLEFT       0x7300
#define PWK_CRIGHT      0x7400
#define PWK_CEND        0x7500
#define PWK_CPGDN       0x7600
#define PWK_CHOME       0x7700
#define PWK_ALT_1       0x7800
#define PWK_ALT_2       0x7900
#define PWK_ALT_3       0x7A00
#define PWK_ALT_4       0x7B00
#define PWK_ALT_5       0x7C00
#define PWK_ALT_6       0x7D00
#define PWK_ALT_7       0x7E00
#define PWK_ALT_8       0x7F00
#define PWK_ALT_9       0x8000
#define PWK_CPGUP       0x8400

/****************************************************************************
** PS/2 extended keys
****************************************************************************/
#define PWK_F11         0x8500
#define PWK_F12         0x8600
#define PWK_AF11        0x8b00
#define PWK_AF12        0x8c00
#define PWK_SF11        0x8700
#define PWK_SF12        0x8800
#define PWK_CF11        0x8900
#define PWK_CF12        0x8a00
#define PWK_NOP         0x4c00                  /* cursor keys: '5' */
#define PWK_CNOP        0x8f00
#define PWK_CDEL        0x9300

#define PWKEY       unsigned int
#define PWCELL      unsigned int
#ifdef POWERLIB
#define PWMENU      struct pw_menu
#define PWWIN       struct pw_window
#else
#define PWMENU      void
#define PWWIN       void
#endif
/****************************************************************************
** Function prototyping for high level window oriented functions
**   Most coordinates are given relative to top left of window 'win'
**   except for: pw_choice(), pw_menu(), pw_open(), pw_select()
**     their coordinates are given relative to top left of screen
****************************************************************************/
unsigned char pw_attrib(int wintype, int texttype);
void   pw_block     (PWWIN *win, int srow, int scol, int nrow, int ncol, int ttype);
PWKEY  pw_choice    (int srow, int scol, int nrow, int ncol, char *header, char * *text, int *element);
void   pw_close     (PWWIN *win);
void   pw_cls       (PWWIN *win);
void   pw_ctrlc     (int (*ExitFunction)(void)); /*AK*/
void   pw_cursor    (PWWIN *win, int row, int col);
int    pw_defkey    (PWKEY key, PWKEY (*KeyFunction)(PWKEY key), PWKEY NewKey);
void   pw_error     (char *format, ...);
void   pw_exit      (int exitcode);
PWCELL pw_getcellat (PWWIN *win, int row, int col);
PWKEY  pw_getkey    (void);
void   pw_hbar      (PWWIN *win, int row);
void   pw_header    (char *header);
PWKEY  pw_hexdump   (int srow, int scol, int nrow, unsigned char far *buf, unsigned bufsize);
void   pw_hide      (PWWIN *win);
void   pw_hscroll   (PWWIN *win, int srow, int scol, int nrow, int ncol, int nscroll);
int    pw_init      (char *argv0, int (*ExitFunction)(void));
PWKEY  pw_input     (PWWIN *win, int tsrow, int tscol, char *text, int srow, int scol, int ncol, char *buf, unsigned int bufsize, char *symbols, int mode);
void   pw_keyinfo   (PWWIN *win, char *keyleft, char *keyright);
PWKEY  pw_menu      (int srow, int scol, int nrow, int ncol, char *header, char * *text, int (*process)(int ), int *element);
int    pw_ncol      (void);
int    pw_nrow      (void);
PWWIN *pw_open      (int srow, int scol, int nrow, int ncol, char *header, int mode, int wtype);
int    pw_options   (int argc, char **argv);
void   pw_pop       (PWWIN *win);
int    pw_putc      (PWWIN *win, int c);
int    pw_putcat    (PWWIN *win, int row, int col, int c);
int    pw_putcell   (PWWIN *win, int c, int ttype);
PWCELL pw_putcellat (PWWIN *win, int row, int col, PWCELL cell);
void   pw_printf    (PWWIN *win, char *format, ...);
void   pw_printfat  (PWWIN *win, int row, int col, char *format, ...);
char  *pw_puts      (PWWIN *win, char *s);
char  *pw_putsat    (PWWIN *win, int row, int col, char *s);
PWKEY  pw_question  (char *question, char *answers, int wtype);
void   pw_quit      (void);
void   pw_refresh   (void);
PWKEY  pw_select    (int srow, int scol, int nrow, int ncol, char *header, int (*proc_action)(PWWIN *, int , int ), int *element);
int    pw_selectdir (int srow, int scol, int nrow, int maxfiles, int *element, char *mask, char *fname);
int    pw_selectfile(int srow, int scol, int nrow, int maxfiles, int *element, char *mask, char *fname);
PWKEY  pw_selectstruct(int srow, int scol, int nrow, int ncol, char *header, void **structarray, void far * far *farstructarray, int (*proc_select)(PWWIN *, int, int), int offset, int *element);
void   pw_shade     (PWWIN *win);
void   pw_show      (PWWIN *win);
int    pw_system    (char *command);
void   pw_vbar      (PWWIN *win, int col);
void   pw_vscroll   (PWWIN *win, int srow, int scol, int nrow, int ncol, int nscroll);
void   pw_waitoff   (void);
void   pw_waiton    (void);
PWKEY  pw_warning   (char *format, ...);
PWWIN *pw_win       (int id);
int    pw_winsrow   (PWWIN *win);
int    pw_winscol   (PWWIN *win);
int    pw_winnrow   (PWWIN *win);
int    pw_winncol   (PWWIN *win);

/****************************************************************************
** Function prototyping for low level window functions
**   All coordinates are given relative to top left of window
****************************************************************************/
void   pws_cursor(int row, int col); /*AK*/
PWKEY  pwl_getkey(void);                    /* no special keys */
int    pwl_kbhit(void);                     /* detects mou & kbd keys */
void   pwl_kbwait(PWKEY (*function)(void)); 
       /* do function while waiting for pws_kbhit()  in pw_getkey() */
       /* do function in pws_kbhit() if no mou or kbd hit           */

#endif

