; *************************************************************************************************
; *
; *	Title:	BROADCST.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to braodcast messages to the console and nodes
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int BROADCAST_TO_CONSOLE( char *MESSAGE )
; *	Sends a message to the main console
; *
; *	Given:
; *		MESSAGE -> string to send to the console of the default fileserver
; *
; *	Returns:
; *		000h if broadcast was done completely
; *		0FFFCh if the message queue is full
; *		0FFFEh if I/O failure or lack of dynamic workspace
; *
; *************************************************************************************************
ifdef WATCOM
broadcast_to_console proc uses es di cx
else
broadcast_to_console proc uses di si, message:ptr
endif
local	request[64]:byte
local	buffer[2]:byte

if @Datasize
	push	ds
ifdef WATCOM
	mov	ds, cx
else
	lds	si, message		; DS:SI -> message to send
endif
else
ifndef WATCOM
	mov	si, message
endif
endif
	mov	ax, ss			; ES:DI -> reply buffer
	mov	es, ax
	lea	di, request+4
	mov	cx, 60
	mov	ah, ' '			; Can't send anything less than this
btc10:
	lodsb				; Get broadcast byte to send
	cmp	al, ah
	jc	short btc20		; Quit if it is < 20h
	stosb
	loop	btc10

btc20:
	lea	di, buffer		; DI -> reply buffer
	lea	si, request
	sub	cx, 60
	neg	cx			; CX = number of bytes to send
	mov	byte ptr [si+3], cl	; Load up the request packet
	mov	byte ptr [si+2], 9
	add	cx, 2
	mov	[si], cx
	mov	ah, 0e1h		; Send broad to the default console
	int	21h
	cbw				; AX = return code
if @Datasize
	pop	ds
endif
	ret
broadcast_to_console endp

	end
