; *************************************************************************************************
; *
; *	Title:	EOJ.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support the End Of Job functions
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int END_OF_JOB( int PROCESS )
; *	Sends an End Of Job signal to the server to closes all semaphores, open files, processes
; *
; *	Given:
; *		PROCESS = 0 is only current process,-1 is all processes at workstation
; *
; *	Returns:
; *		0 if call was successful
; *		-1 = network error
; *
; *************************************************************************************************
ifdef WATCOM
end_of_job proc
else
end_of_job proc, process:word
endif
	mov	ah, 0d6h		; End of Job
ifdef WATCOM
	neg	bx
	sbb	bx, bx
else
	neg	process			; Set CARRY if !0, otherwise CARRY cleared
	sbb	bx, bx			; BX = -1 if CARRY set
endif
	int	21h
	sbb	ax, ax			; AX = -1 if CARRY set

	ret
end_of_job endp

	end



