; *************************************************************************************************
; *
; *	Title:	GETCOUNT.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support retrieving a count associated
; *	with a semaphore.
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int GET_SEMAPHORE_COUNT( long HANDLE )
; *	Gets the number of opens associated with a semaphore handle
; *
; *	Given:
; *		HANDLE = handle of the semaphore of interest
; *
; *	Returns:
; *		Number of processes that have this semaphore open
; *		-1 if invalid semaphore handle
; *
; *************************************************************************************************
get_semaphore_count proc, handle:dword

	mov	ax, 0c501h		; Examine semaphore
	mov	dx, word ptr handle
	mov	cx, word ptr handle+2
	int	21h
	cbw				; Convert to a word
	or	ax, ax			; See if an error return
	jnz	done_get

	mov	al, dl			; AX = semaphore count

done_get:
	ret
get_semaphore_count endp

	end

