; *************************************************************************************************
; *
; *	Title:	GETVALUE.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support retrieving a value associated
; *	with a semaphore.
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int GET_SEMAPHORE_VALUE( long HANDLE )
; *	Gets the value associated with a semaphore handle
; *
; *	Given:
; *		HANDLE = handle of the semaphore of interest
; *
; *	Returns:
; *		Current value of the semaphore, -127 to 127
; *		A positive value indicates that the application can access the resource that is
; *		associated with the semaphore.  A negative value indicates that the application
; *		must either enter a waiting queue by calling wait_semaphore() or abandon hope of
; *		accessing the resource.
; *		-128 if invalid semaphore handle
; *
; *************************************************************************************************
get_semaphore_value proc, handle:dword

	mov	ax, 0c501h		; Examine semaphore
	mov	dx, word ptr handle
	mov	cx, word ptr handle+2
	int	21h
	or	ax, ax			; See if an error return
	mov	ax, -128
	jnz	done_get

	mov	ax, cx			; AX = semaphore value

done_get:
	ret
get_semaphore_value endp

	end

