; *************************************************************************************************
; *
; *	Title:	IPXCANCL.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support cancelling an event defined by an ECB
; *
; *************************************************************************************************

_IPXCANCL_ASM_	equ	1

	include network.inc


.code
; *************************************************************************************************
; *
; *	int IPX_CANCEL_ECB( ECB_HEADER_T far *ECB_PTR )
; *	Cancels an event defined by an ECB
; *
; *	Given:
; *		ECB_PTR -> ECB to cancel
; *
; *	Returns:
; *		0 if ECB was cancelled
; *		0xFFF9 if ECB can't be cancelled
; *		0xFFFF if ECB is not currently in use
; *
; *************************************************************************************************
ipx_cancel_ecb proc uses di si, ecb_ptr:dword

	les	si, ecb_ptr		; ES:SI -> ECB to cancel
	IPX	6			; IPX Cancel Event command
	cbw				; Change to 16-bit return
	ret

ipx_cancel_ecb endp

	end

