; *************************************************************************************************
; *
; *	Title:	IPX_ADD.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support adding a new listening packet to IPX
; *
; *************************************************************************************************

_IPX_ADD_ASM_	equ	1

	include network.inc


.code
; *************************************************************************************************
; *
; *	int IPX_ADD_LISTENER( ECB_HEADER_T far *ECB_PTR )
; *	Adds a packet to the listening chain
; *
; *	Given:
; *		ECB_PTR -> ECB to add to the listening chain
; *
; *	Returns:
; *		0 if ECB was added in successfully
; *		0xFFFF if listening socket does not exist
; *
; *************************************************************************************************
ipx_add_listener proc uses di si, ecb_ptr:dword

	les	si, ecb_ptr		; ES:SI -> ECB to cancel
	IPX	4			; IPX Listen For Packet command
	cbw				; Change to 16-bit return
	ret

ipx_add_listener endp

	end


