/**************************************************************************************************
*
*		Title:	IPX_ORPH.C
*		Copyright (c) January 1992, Ryu Consulting, 916/722-1939
*		Written by Rahner James
*
*		This file contains all the functions that support reading orphaned IPX packets
*
**************************************************************************************************/

#define	_IPX_ORPH_C_
#include	<dos.h>
#include	<malloc.h>
#include	<stdlib.h>
#include	<time.h>
#include	"network.h"


/**************************************************************************************************
*
*	ORPHAN_T far *IPX_READ_ORPHAN( ORPHAN_T far *OP )
*	Reads the next orphaned packet from the queue
*
*	Given:
*		OP -> buffer to place the orphan, if NULL space will be allocated
*
*	Returns:
*		Pointer to the allocated orphan buffer, packet is returned to the listening pool
*		If there are no orphans or if there is no memory, returns NULL
*
**************************************************************************************************/
ORPHAN_T far *ipx_read_orphan( ORPHAN_T far *op )
{
	SPX_PACKET_T	far *pp;

	if ( _Total_Nomatchs == 0 )
		return NULL;
	if ( op == NULL )
	{
		if ( (op=halloc(_First_Nomatch->buffer_size+sizeof(ORPHAN_T)-1,1)) == NULL )
			return NULL;
	}

/*
** Disconnect the orphan packet from the homeless list
*/
	_disable();
	--_Total_Nomatchs;
	pp = _First_Nomatch;
	if ( (_First_Nomatch = pp->next_sibling) == NULL )
		_Last_Nomatch = NULL;

/*
** Transfer the pertinent packet informtion
*/
	farmove( &op->src, &pp->src, sizeof(NET_ADDRESS_T) );
	farmove( op->buffer, pp->buffer_ptr, op->length = pp->buffer_size );
	_enable();

	pp->buffer_ptr = pp->default_buffer;
	pp->buffer_size = pp->default_size;
	ipx_add_listener( (ECB_HEADER_T far *)pp );

	return op;
}

