; *************************************************************************************************
; *
; *	Title:	IPX_TARG.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support getting a local address from a full
; *	internetwork address
; *
; *************************************************************************************************

_IPX_TARG_ASM_	equ	1

	include network.inc


.code
; *************************************************************************************************
; *
; *	int IPX_TARGET( char far *LOCAL_ADDRESS, char far *FULL_ADDRESS )
; *	Generates a local address from a full internetwork address
; *
; *	Given:
; *		LOCAL_ADDRESS -> 6 byte buffer for the local address
; *		FULL_ADDRESS -> 10 byte full internetwork address
; *
; *	Returns:
; *		Number of system ticks to send the packet to the destination
; *		-6 if no path to the destination was found
; *
; *************************************************************************************************
ipx_target proc, local_address:dword, full_address:dword
local	dest[3]:word
local	src[5]:word

	les	bx, full_address	; ES:BX -> full address
	push	di			; Save our registers
	push	si

	lea	si, src			; SI -> our local buffer
	lea	di, dest
	mov	ax, es:[bx]
	mov	[si], ax
	mov	ax, es:[bx+2]
	mov	[si+2], ax
	mov	ax, es:[bx+4]
	mov	[si+4], ax
	mov	ax, es:[bx+6]
	mov	[si+6], ax
	mov	ax, es:[bx+8]
	mov	[si+8], ax
	mov	ax, ss			; ES = SS
	mov	es, ax
	IPX	2			; IPX Get Local Target command
	pop	si			; Restore registers
	pop	di
	cbw
	or	ax, ax			; See if we got an error
	jnz	done_ipx_target		; Quit if error

	les	bx, local_address	; ES:BX -> local address
	mov	ax, dest
	mov	es:[bx], ax
	mov	ax, dest+2
	mov	es:[bx+2], ax
	mov	ax, dest+4
	mov	es:[bx+4], ax

	mov	ax, cx			; AX = number system ticks to transport

done_ipx_target:
	ret

ipx_target endp

	end


