; *************************************************************************************************
; *
; *	Title:	OPENSOCK.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support opening an IPX socket
; *
; *************************************************************************************************

_OPENSOCK_ASM_	equ	1

	include network.inc


.code
; *************************************************************************************************
; *
; *	int IPX_OPEN_SOCKET( us far *SOCKET )
; *	Opens an IPX socket
; *
; *	Given:
; *		SOCKET -> socket number to open, 0 will allow IPX to select the next available socket
; *
; *	Returns:
; *		0 if socket was opened
; *		-1 if socket already open
; *		-2 if socket table is full
; *
; *************************************************************************************************
ipx_open_socket proc uses di si, socket_ptr:dword

	les	di, socket_ptr		; ES:DI -> socket variable to fill
	mov	dx, es:[di]
	mov	al, _Socket_Life
	IPX	0			; IPX Open Socket command
	cbw
	or	ax, ax			; See if there was an error return
	jnz	done_open_socket	; Skip if there was
	les	di, socket_ptr
	mov	es:[di], dx		; Replace old value with socket number we actually opened

done_open_socket:
	ret

ipx_open_socket endp

	end



