; *************************************************************************************************
; *
; *	Title:	SEMAPHOR.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support semaphores on a Novell network
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int OPEN_SEMAPHORE( char *SEMAPHORE, char INITIAL, char *COUNT, long *HANDLE )
; *	Opens a semaphore with a particular name
; *
; *	Given:
; *		SEMAPHORE -> name of the semaphore to open
; *		INITIAL = initial count
; *		COUNT -> filled with current number of opens doen to this semaphore
; *		HANDLE -> filled with the open semaphore handle
; *
; *	Returns:
; *		0 if semaphore is open a ready for business
; *		0FFFFh if invalid name length
; *		0FFFEh if invalid name
; *
; *************************************************************************************************
open_semaphore proc uses di si, semaphore:ptr, initial:byte, count:ptr, handle:ptr
local	request[128]:byte

if @Datasize
	push	ds
	lds	si, semaphore		; DS:SI -> semaphore to open
else
	mov	si, semaphore
endif
	mov	ax, ss			; ES:DI -> its place in the stack
	mov	es, ax
	lea	di, request+1
	mov	cx, 127
open10:
	lodsb				; Get the semaphore name byte
	or	al, al			; Check for Arnold
	jz	open20			; Quit looping if done
	stosb
	loop	open10

open20:
	lea	dx, request		; DS:DX -> request packet
	sub	cx, 127
	neg	cx			; CX = number of bytes in the semaphore name
	mov	request, cl		; Load up the request packet
	mov	cl, initial
	mov	ax, 0c500h		; Open the semaphore
	int	21h
	or	al, al			; See if an error
	jnz	done_open		; Quit if there is one

if @Datasize
	lds	si, count
	mov	ax, ds
	or	ax, si
	jz	open30
else
	mov	si, count
	or	si, si
	jz	open30
endif
	mov	[si], bl		; Save the count

open30:
if @Datasize
	lds	si, handle
else
	mov	si, handle
endif
	mov	[si], dx		; Save the handle
	mov	[si+2], cx

	xor	ax, ax			; Return good
done_open:
	cbw				; AX = return code
if @Datasize
	pop	ds
endif
	ret
open_semaphore endp


; *************************************************************************************************
; *
; *	int close_semaphore( long HANDLE )
; *	Closes a semaphore associated with a handle
; *
; *	Given:
; *		HANDLE = handle of the semaphore to close
; *
; *	Returns:
; *		000h if semaphore is open a ready for business
; *		0FFFFh if invalid handle
; *
; *************************************************************************************************
close_semaphore proc, handle:dword

	mov	ax, 0c504h		; Close semaphore command
	mov	dx, word ptr handle
	mov	cx, word ptr handle+2
	int	21h
	cbw
	ret

close_semaphore endp

	end

