; *************************************************************************************************
; *
; *	Title:	SIGLSEMA.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support signalling a semaphore.
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int SIGNAL_SEMAPHORE( long HANDLE )
; *	Signals a semaphore that a process has relinquished the use of a resource
; *
; *	Given:
; *		HANDLE = handle of the semaphore of interest
; *
; *	Returns:
; *		0 if the resource has been released
; *		1 = semaphore overflow
; *		-1 = invalid handle
; *
; *	Note:
; *		The process must call this function after finishing with its use of the
; *		network resource that is associated with this semaphore
; *
; *************************************************************************************************
signal_semaphore proc, handle:dword

	mov	ax, 0c503h		; Signal a semaphore
	mov	dx, word ptr handle
	mov	cx, word ptr handle+2
	int	21h
	cbw				; Convert AL to a word

	ret
signal_semaphore endp

	end


