; *************************************************************************************************
; *
; *	Title:	SPX_ADD.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support adding a new listening packet to SPX
; *
; *************************************************************************************************

_SPX_ADD_ASM_	equ	1

	include network.inc


.code
; *************************************************************************************************
; *
; *	int SPX_ADD_LISTENER( ECB_HEADER_T far *ECB_PTR )
; *	Adds a packet to the listening chain
; *
; *	Given:
; *		ECB_PTR -> ECB to add to the listening chain
; *
; *	Returns:
; *		0 if ECB was added in successfully
; *		0xFFFF if listening socket does not exist
; *
; *************************************************************************************************
spx_add_listener proc uses di si, ecb_ptr:dword

	les	si, ecb_ptr		; ES:SI -> ECB to cancel
	IPX	17h			; SPX Listen For Sequenced Packet command
	xor	ax, ax			; Always returns 0
	ret

spx_add_listener endp

	end



