; *************************************************************************************************
; *
; *	Title:	SPX_EST.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support sending an SPX packet
; *
; *************************************************************************************************

_SPX_EST_ASM_	equ	1

	include	network.inc

.data
	extern	_SPX_Retry_Count:byte, _SPX_Bowser_Flag:byte

.code
; *************************************************************************************************
; *
; *	int SPX_ESTABLISH_COMMUNICATION( ECB_HEADER_T far *ECB_PTR, unsigned short ID )
; *	Attempts to establish an SPX connection with a specific node address and socket
; *
; *	Given:
; *		ECB_PTR -> ECB to use for connection
; *
; *	Returns:
; *		Returns error code if there is one
; *		Connection ID placed in *ID
; *
; *************************************************************************************************
spx_establish_communication proc uses di si, ecb_ptr:dword, id:dword

	les	si, ecb_ptr		; ES:SI -> ECB to send
	mov	ah, _SPX_Bowser_Flag	; AH = watchdog flag
	mov	al, _SPX_Retry_Count	; AL = retry count, 0 uses default SPX count
	IPX	11h			; IPX Send Packet command
	cbw
	les	si, id			; Set the connection ID whether we got an error or not
	mov	es:[si], dx

	ret

spx_establish_communication endp

	end




