#include <rjuser.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "network.h"


typedef struct IPX_PACKET_S
{
	struct IPX_PACKET_T far *next;	// Used by IPX/SPX when the ECB is active
	void (far *function)(void);		// Called after packet sent/recd, called ESR, 			* s,r
	unsigned char	in_use;			// Set to !0 by IPX/SPX when packet is in use
	unsigned char	completion_code;// Set by IPX/SPX after packet task is complete
	unsigned short	socket;			// Socket to use for this ECB							* s,r
	unsigned char	IPX_work[4];	// Workspace used internally by IPX
	unsigned char	driver_work[12];// Workspace used internally by the IPX driver
	unsigned char	dest_address[6];// Destination address of this packet					* s
	unsigned short	fragment_count;	// Fragments descriptors that follow					* s,r
	IPX_T far *		hdr;			// -> IPX/SPX packet descriptor to use					* s,r
	unsigned short	size_hdr;		// Size of the IPX(30) or SPX(42) descriptor			* s,r
	void far *		buffer_ptr;		// -> data buffer to use for transmission/reception		* s,r
	unsigned short	buffer_size;	// Number of bytes in that buffer						* s,r

	void far *		next_allocated;	// -> next allocated packet structure					* set by IPX_OPEN
	void far *		next_sibling;	// -> next packet associated with handle and condition	* various functions
	void far *		default_buffer;	// -> default buffer to use for IPX or SPX				* set by IPX_OPEN
	unsigned short	default_size;	// Size of the default buffer							* set by IPX_OPEN
	char far *		done_flag;		// Set by the ESR with the completion code				* set by IPX_READ,IPX_WRITE

	unsigned short	checksum;		// Dummy checksum of the 30-byte packet header
	unsigned short	length;			// Length of the complete IPX packet, filled by IPX/SPX
	unsigned char	control;		// Transport control byte for internetwork bridges
	unsigned char	type;			// Packet type: IPX(4)/SPX(5), defined by Xerox			* s
	NET_ADDRESS_T	dest;			// Destination node address								* s
	NET_ADDRESS_T	src;			// Source node address, filled by IPX/SPX
} IPX_PACKET_T;


typedef struct SPX_PACKET_S
{
	struct SPX_PACKET_T far *next;	// Used by IPX/SPX when the ECB is active
	void (far *function)(void);		// Called after packet sent/recd, called ESR, 			* s,r
	unsigned char	in_use;			// Set to !0 by IPX/SPX when packet is in use
	unsigned char	completion_code;// Set by IPX/SPX after packet task is complete
	unsigned short	socket;			// Socket to use for this ECB							* s,r
	unsigned char	IPX_work[4];	// Workspace used internally by IPX
	unsigned char	driver_work[12];// Workspace used internally by the IPX driver
	unsigned char	dest_address[6];// Destination address of this packet					* s
	unsigned short	fragment_count;	// Fragments descriptors that follow					* s,r
	IPX_T far *		hdr;			// -> IPX/SPX packet descriptor to use					* s,r
	unsigned short	size_hdr;		// Size of the IPX(30) or SPX(42) descriptor			* s,r
	void far *		buffer_ptr;		// -> data buffer to use for transmission/reception		* s,r
	unsigned short	buffer_size;	// Number of bytes in that buffer						* s,r

	void far *		next_allocated;	// -> next allocated packet structure					* set by IPX_OPEN
	void far *		next_sibling;	// -> next packet associated with handle and condition	* various functions
	void far *		default_buffer;	// -> default buffer to use for IPX or SPX				* set by IPX_OPEN
	unsigned short	default_size;	// Size of the default buffer							* set by IPX_OPEN
	char far *		done_flag;		// Set by the ESR with the completion code				* set by IPX_READ,IPX_WRITE

	unsigned short	checksum;		// Dummy checksum of the 30-byte packet header
	unsigned short	length;			// Length of the complete IPX packet, filled by IPX/SPX
	unsigned char	control;		// Transport control byte for internetwork bridges
	unsigned char	type;			// Packet type: IPX(4)/SPX(5), defined by Xerox			* s
	NET_ADDRESS_T	dest;			// Destination node address								* s
	NET_ADDRESS_T	src;			// Source node address, filled by IPX/SPX

	struct
	{
		unsigned char reserved1:4;	// Reserved for future use
		unsigned char end_of_msg:1;	// End of message
		unsigned char reserved2:1;	// Reserved for future use
		unsigned char ACK_req:1;	// Acknowledge required
		unsigned char sys_packet:1;	// System packet
	} con_control;					// Connection control structure
	unsigned char	datastream;		// Datastream type, 0x00-0xFD can be used by application	* s
	unsigned short	src_ID;			// Source connection ID, used by SPX, filled by SPX
	unsigned short	dest_ID;		// Destination connection ID, used by SPX, filled by SPX
	unsigned short	sequence;		// Sequence number to keep track of the packet sequence
	unsigned short	ACK_number;		// Acknowledge number
	unsigned short	allocation;		// Allocation number
} SPX_PACKET_T;




IPX_PACKET_T	Talk, Listen;
char Talk_Buffer[1000], Listen_Buffer[1000];

volatile us		ISR_Count=0, Talk_Count=0, Listen_Count=0;
extern	void far esr_isr( void );


main( int argc, char *argv[] )
{
	int		rv;
	us		socket=0;
	long	handle=0, ticks;
	long	packets_received=0, other_nodes=0;
	char	count;

	print( "\fTest Program" );

	if ( argc > 1 )
		socket = atoi( argv[1] );
	print( "\nReturn from ipx_init(%d) = %d", socket, rv=ipx_init(socket) );
	if ( rv == 0 )
	{
		print( "\nNetwork address = %ld", _Our_Address.network );
		print( "\nNode address =    %02X%02X%02X%02X%02X%02X",	_Our_Address.node[0], _Our_Address.node[1], _Our_Address.node[2],
																_Our_Address.node[3], _Our_Address.node[4], _Our_Address.node[5] );
		print( "\nSocket = %d", _Our_Address.socket );
		socket = _Our_Address.socket;
	}
	else
		exit( 1 );
	charin();

/*
** Set up the structures
*/
	memset( &Talk, 0, sizeof(IPX_PACKET_T) );
	memset( &Listen, 0, sizeof(IPX_PACKET_T) );
	Talk.function = Listen.function = esr_isr;
	Talk.socket = Listen.socket = socket;
	Talk.fragment_count = Listen.fragment_count = 2;
	Talk.hdr = (IPX_T far *)&Talk.checksum;
	Talk.buffer_ptr = Talk_Buffer;
	Talk.buffer_size = 200;
	Listen.hdr = (IPX_T far *)&Listen.checksum;
	Listen.buffer_ptr = Listen_Buffer;
	Listen.buffer_size = 200;
	Talk.size_hdr = Listen.size_hdr = 30;

	Talk.type = Listen.type = 4;

	sprintf( Talk_Buffer, "Hello from node %02X%02X%02X%02X%02X%02X",
		_Our_Address.node[0], _Our_Address.node[1], _Our_Address.node[2],
		_Our_Address.node[3], _Our_Address.node[4], _Our_Address.node[5] );
	Talk.buffer_size = strlen( Talk_Buffer );

/*
** Set the listener and send the talker
*/
	ipx_add_listener( (ECB_T far *)&Listen );
	while ( !kbhit() )
	{
		if ( Talk.in_use == 0 )
		{
			print( "\nSending at %ld", ticks = clock() );
			Talk.dest.network = _Our_Address.network;
			memset( Talk.dest.node, 0xff, 6 );
			memset( Talk.dest_address, 0xff, 6 );
			Talk.dest.socket = socket;
			Talk.socket = socket;
			ipx_send_packet( (ECB_T far *)&Talk );
			print( ", IPX packet sent" );
		}
		print( "\nTalk completion = %X", Talk.in_use );

		while ( clock() < ticks+CLOCKS_PER_SEC*3 )
		{
			if ( kbhit() )
				break;
			if ( Listen.in_use == 0 )
			{
				print( "\nPacket %ld received from ", ++packets_received );
				if ( memcmp(Listen.src.node,_Our_Address.node,6) == 0 )
				{
					print( "us." );
				}
				else
				{
					++other_nodes;
					print( "%02X%02X%02X%02X%02X%02X",
						Listen.src.node[0], Listen.src.node[1], Listen.src.node[2],
						Listen.src.node[3], Listen.src.node[4], Listen.src.node[5] );
				}
				ipx_add_listener( (ECB_T far *)&Listen );
				print( "\nListen completion = %X", Listen.in_use );
			}
		}
	}
	charin();

	print( "\n\nPackets received: %ld\t\tOther nodes: %ld", packets_received, other_nodes );
	print( "\nISR_Count = %d", ISR_Count );
	print( "\nTalk_Count = %d,    Listen_Count = %d", Talk_Count, Listen_Count );
	ipx_close_socket( socket );
}
