; *************************************************************************************************
; *
; *	Title:	WAITSEMA.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support waiting on a semaphore.
; *
; *************************************************************************************************


	include network.inc

.code
; *************************************************************************************************
; *
; *	int WAIT_SEMAPHORE( long HANDLE, us TICKS )
; *	Waits for semaphore to indicate resource readiness
; *
; *	Given:
; *		HANDLE = handle of the semaphore of interest
; *		TICKS = number of systems ticks to wait for the semaphore to indicate readiness
; *
; *	Returns:
; *		0 if the resource is ready for action
; *		-1 = invalid handle
; *		-2 = timeout failure
; *
; *	Note:
; *		This does not return until either the semaphore indicates that the resource is
; *		ready or the number of system ticks expire (1/18th of a second per tick)
; *
; *************************************************************************************************
wait_semaphore proc, handle:dword, ticks:word

	mov	ax, 0c502h		; Wait on semaphore
	mov	dx, word ptr handle
	mov	cx, word ptr handle+2
	push	bp			; Save BP for God's sake
	mov	bp, ticks
	int	21h
	pop	bp			; Restore BP for the stack's sake
	cbw				; Convert AL to a word

	ret
wait_semaphore endp

	end


