; *************************************************************************************************
; *
; *	Title:	WFARSET.ASM
; *	Copyright (c) January 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains the functions for far manipulations
; *
; *************************************************************************************************

_WFARSET_ASM_	equ	1

ifdef	LARGEMODEL
	.model	large,c
else
	.model	small,c
endif


.code
; *************************************************************************************************
; *
; *	void far *FARSET( void far *ES:DI, char AL, unsigned int CX )
; *	Sets a buffer to bytes of VALUE
; *
; *	Given:
; *		ES:DI -> buffer to set
; *		AL = byte to set the buffer to
; *		CX = number of bytes to do
; *
; *	Returns:
; *		ES:BX -> buffer
; *
; *	Note:
; *		This function assumes that the buffers in question will start on even boundaries
; *		because they all deal with allocated far memory buffers
; *		It also assumes that the buffer resides within one 64K segment
; *
; *************************************************************************************************
farset proc

	mov	bx, di			; Return pointer in ES:BX

	mov	ah, al
	shr	cx, 1			; CX = number of words to set
	rep	stosw
	adc	cx, cx
	rep	stosb

	ret

farset endp


; *************************************************************************************************
; *
; *	void far *FARMOVE( void far *DEST, void far *SOURCE, unsigned int COUNT )
; *	Moves a number of bytes from one fram memory buffer to another
; *
; *	Given:
; *		DEST -> buffer to move the bytes to
; *		SOURCE -> buffer to copy the bytes from
; *		COUNT = number of bytes to do
; *
; *	Returns:
; *		-> destination buffer
; *
; *	Note:
; *		This function assumes that the buffers in question will start on even boundaries.
; *		It also assumes that both buffers reside within single 64K segments and
; *		do not overlap in any way
; *
; *************************************************************************************************
farmove proc uses di si ds, dest:dword, source:dword, count:word

	cld
	les	di, dest		; ES:DI -> destination buffer
	lds	si, source		; DS:SI -> source buffer
	mov	ax, di			; AX = offset of return value
	mov	cx, count		; CX = number of bytes to move
	shr	cx, 1			; CX = number of words to move
	rep	movsw
	adc	cx, cx
	rep	movsb

	mov	dx, es
	ret

farmove endp


; *************************************************************************************************
; *
; *	int FARCMPW( void far *BUFFER1, void far *BUFFER2, unsigned int COUNT )
; *	Compares one buffer to another, a word at a time
; *
; *	Given:
; *		BUFFER1 -> first buffer to compare
; *		BUFFER2 -> second buffer to compare
; *		COUNT = number of bytes to compare
; *
; *	Returns:
; *		0 if same
; *
; *	Note:
; *		This function assumes that the buffers in question will start on even boundaries.
; *		It also assumes that both buffers reside within single 64K segments and are
; *		comprised of an even number of bytes
; *
; *************************************************************************************************
farcmpw proc uses di si ds, buffer1:dword, buffer2:dword, count:word

	cld
	xor	ax, ax
	les	di, buffer1		; ES:DI -> first buffer
	lds	si, buffer2		; DS:SI -> second buffer
	mov	cx, count		; CX = number of bytes to move
	shr	cx, 1			; CX = number of words to move
	repe	cmpsw
	je	@F
	adc	ax, ax			; AX = 1 if buffer1 > buffer2, otherwise 0
	add	ax, ax			; AX = 2 if buffer1 > buffer2, otherwise 0
	dec	ax			; AX = 1 if buffer1 > buffer2, otherwise -1

@@:	ret

farcmpw endp


; *************************************************************************************************
; *
; *	void ATOADDR( char far *ADDRESS, char far *STRING )
; *	Converts an ASCII string into an IPX/SPX node address
; *
; *	Given:
; *		ADDRESS -> IPX/SPX 6-byte node address 
; *		STRING -> ASCII string to convert, assumed to be 6 bytes or end with a 0
; *
; *	Returns:
; *		ASCII string converted into a node address
; *
; *	Note:
; *		This function was written for those of you who have a need for speed.
; *		This does not range checking.  You must be sure of the values provided
; *		otherwise you will get bizarro binary
; *
; *************************************************************************************************
atoaddr proc uses di si ds, address:dword, string:dword

	cld
	les	di, address		; ES:DI -> IPX/SPX node address buffer
	lds	si, string		; DS:SI -> ASCII representation of an IPX/SPX node address
	mov	cx, 604h		; CH = loop counter, CL = shifter
atoaddr10:
	lodsw				; Get two digits at a time
	sub	al, '0'			; Convert to binary
	cmp	al, 10			; See if < 10
	jc	@F			; Skip if we are < 10
	and	al, 7			; Get rid of the upper
	add	al, 9			; Dwell on the lower, no matter if it is upper or lower case

@@:	sub	ah, '0'			; Convert to upper nibble
	cmp	ah, 10			; See if < 10
	jc	@F			; Skip if we are < 10
	and	ah, 7			; Get rid of the upper
	add	ah, 9			; Dwell on the lower, no matter if it is upper or lower case

@@:	shl	al, cl			; Move lower byte bits into upper nibble
	or	al, ah			; Bring on Mr. Low Nibble
	stosb				; Store them together, like peas with a STOSB
	dec	ch
	jnz	atoaddr10		; Loop if this is a National Socialist

	ret

atoaddr endp


; *************************************************************************************************
; *
; *	void ADDRTOA( char far *STRING, char far *ADDRESS )
; *	Converts an IPX/SPX node address into an ASCII string
; *
; *	Given:
; *		STRING -> ASCII string to convert, assumed to be 6 bytes or end with a 0
; *		ADDRESS -> IPX/SPX 6-byte node address 
; *
; *	Returns:
; *		Node address converted to ASCII string
; *
; *	Note:
; *		This function was written for those of you who have a need for speed.
; *		This does not range checking.  You must be sure of the values provided
; *		otherwise you will get bizarro binary
; *
; *	Uses:
; *		This function uses the following table:
ascii_table		db	'0123456789ABCDEF'
; *		for looking up the ASCII hexadecimal conversion letters
; *
; *************************************************************************************************
addrtoa proc uses di si ds, string:dword, address:dword

	cld
	les	di, string		; ES:DI -> ASCII representation of an IPX/SPX node address
	lds	si, address		; DS:SI -> IPX/SPX node address buffer
	mov	cx, 604h		; CH = loop counter, CL = shifter
	mov	bx, offset ascii_table	; BX -> lookup table
@@:	xor	ah, ah			; AH = 0
	lodsb				; Get two binary digits at a time
	ror	ax, cl			; Put LSNibble in AH, old MSNibble -> LSNibble
	xlat	cs:ascii_table		; Translate to ASCII in AL
	stosb
	mov	al, ah
	shr	al, cl
	xlat	cs:ascii_table		; Translate to ASCII in AL
	stosb
	dec	ch			; One less byte for mankind
	jnz	@B

	mov	byte ptr es:[di], 0	; Put in Arnold

	ret

addrtoa endp


; *************************************************************************************************
; *
; *	int ISBROADCAST( char far *ADDRESS )
; *	Determines the brodcast-ity of an address, eg is it all 0xFFs
; *
; *	Given:
; *		ADDRESS -> IPX/SPX 6-byte node address to check
; *
; *	Returns:
; *		0 if it is not, !0 if it is
; *
; *************************************************************************************************
isbroadcast proc, address:dword

	les	bx, address		; ES:BX -> node address to check
	mov	ax, es:[bx]		; AND all the words together
	and	ax, es:[bx+2]
	and	ax, es:[bx+4]
	add	ax, 1			; Sets CARRY only if AX == 0xFFFF
	sbb	ax, ax			; AX = 1 if CARRY set, otherwise it's 0
	ret

isbroadcast endp

	end

