unit Time;
{**********************************************************************
 *                         TCP/IP TIME CLIENT                         *
 *                                                                    *
 * Written by:  Gary T. Desrosiers                                    *
 * Date:        May 1st, 1995.                                        *
 * Copyright:   (R) Copyright by Gary T. Desrosiers, 1995.            *
 *               All Rights Reserved                                  *
 * UserID(s):   71062,2754                                            *
 *              desrosi@pcnet.com                                     *
 *                                                                    *
 * Description: TCP/IP time client that uses the tcp port 37 server   *
 *              (TIMED). Retrieves the server's time/date and compares*
 *              to the local time/date. If there is a difference, the *
 *              local time/date is reset to the server's time/date.   *                   *
 *              This program uses the "SOCKETS" VCL that is available *
 *              in the VCL section of the Delphi forum on compuserve. *
 *              You must have a time daemon available on you're       *
 *              network and know it's IP address.                     *
 **********************************************************************}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, ExtCtrls, Sockets;
type
  Ttimefrm = class(TForm)
    Edit1: TEdit;
    Timer1: TTimer;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Sockets1: TSockets;
    procedure pbGetTimeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Sockets1DataAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1SessionClosed(Sender: TObject; Socket: Word);
    procedure Sockets1SessionConnected(Sender: TObject; Socket: Word);
  private
  public
  end;
  timerec = record
    len: char;
    Case integer of
    0: (t_b1, t_b2, t_b3, t_b4: char);
    1: (t_time: longint);
  end;

var
  timefrm: Ttimefrm;
  line: string;
  hosttime: timerec;
  MonthDays: array[1..12] of integer;
  ServerIP: string;
  TZ: longint; { Time Zone Offset }

implementation

{$R *.DFM}

procedure Ttimefrm.pbGetTimeClick(Sender: TObject);
begin
  line := '';
  if ServerIP = '' then
  begin
    ServerIP := InputBox('Enter IP Address of time daemon', 'IP Addr: ', 'timeserver');
    TZ := StrToInt(InputBox('Enter offset from Greenwich England', 'GMT Offset: ', '-4'));
    Timer1.Enabled := True;
  end;
  Sockets1.IPAddr := ServerIP;
  Sockets1.Port := 'time';
  Sockets1.SConnect;
end;

procedure Ttimefrm.FormCreate(Sender: TObject);
begin
  pbGetTimeClick(self);
end;

procedure Ttimefrm.Sockets1DataAvailable(Sender: TObject; Socket: Word);
var
  epoch: longint;
  days: longint;
  hours: longint;
  minutes: longint;
  seconds: longint;
  year: longint;
  month: longint;
  i: integer;
  leap: integer;
  dosYear: integer;
  dosHoursDisp: integer;
  temp: char;
  dosHours: char;
  dosMinutes: char;
  dosSeconds: char;
  dosStatus: char;
  dosDay: char;
  dosMonth: char;
  AmPm: string[2];
  buf: string absolute hosttime;
begin
  buf := Sockets1.Text;
  temp := hosttime.t_b1;
  hosttime.t_b1 := hosttime.t_b4;
  hosttime.t_b4 := temp;
  temp := hosttime.t_b2;
  hosttime.t_b2 := hosttime.t_b3;
  hosttime.t_b3 := temp;
  epoch := $83aa7e80; {2208988800 is negative if signed}
  hosttime.t_time := hosttime.t_time - epoch;
  hosttime.t_time := hosttime.t_time + 3600*TZ+1;
  days := hosttime.t_time div 86400;
  hosttime.t_time := hosttime.t_time - (days * 86400);
  inc(days);
  hours := hosttime.t_time div 3600;
  hosttime.t_time := hosttime.t_time - (hours * 3600);
  minutes := hosttime.t_time div 60;
  seconds := hosttime.t_time - (minutes * 60);
  asm { get dos time. And while we're at it, get the date too }
    mov ah,2ch
    int 21h
    mov dosHours,ch
    mov dosMinutes,cl
    mov dosSeconds,dh
    mov ah,2ah
    int 21h
    mov dosYear,cx
    mov dosMonth,dh
    mov dosDay,dl
  end;
  Edit4.Text := copy('  JanFebMarAprMayJunJulAugSepOctNovDec',
    integer(dosMonth)*3,3) + ' ' + IntToStr(integer(dosDay)) +
    ' ,' + IntToStr(dosYear);
  AmPm := 'AM';
  dosHoursDisp := integer(dosHours);
  if dosHoursDisp > 12 then
    begin
      AmPm := 'PM';
      dosHoursDisp := dosHoursDisp - 12;
    end;
  if dosHoursDisp = 0 then
    dosHoursDisp := 12;
  Edit3.Text := Format('%2.2d',[integer(dosHoursDisp)]) + ':' +
    Format('%2.2d',[integer(dosMinutes)]) + ':' +
    Format('%2.2d',[integer(dosSeconds)]) + ' ' + AmPm;
  if (hours <> integer(dosHours)) or
     (minutes <> integer(dosMinutes)) or
     (seconds <> integer(dosSeconds))then
    begin
      dosHours := char(hours);
      dosMinutes := char(minutes);
      dosSeconds := char(seconds);
      asm { set time through dos services }
        mov ch,dosHours
        mov cl,dosMinutes
        mov dh,dosSeconds
        mov dl,70
        mov ah,2dh
        int 21h
        mov dosStatus,al
      end;
    end;
  AmPm := 'AM';
  if Hours > 12 then
    begin
      Hours := Hours - 12;
      AmPm := 'PM';
    end;
  if Hours = 0 then
    Hours := 12;
  Edit1.Text := Format('%2.2d',[hours]) + ':' +
    Format('%2.2d',[minutes]) + ':' +
    Format('%2.2d',[seconds]) + ' ' + AmPm;
  leap := 1;
  for year := 70 to 99 do
    begin
      if leap = 3 then
      begin
          leap := 0;
          if days > 366 then
            days := days - 366
          else
            break;
        end
      else
        begin
          inc(leap);
          if days > 365 then
            days := days - 365
          else
            break;
        end
    end;
  MonthDays[1] := 31;
  if leap = 0 then
    MonthDays[2] := 29
  else
    Monthdays[2] := 28;
  MonthDays[3] := 31;
  MonthDays[4] := 30;
  MonthDays[5] := 31;
  MonthDays[6] := 30;
  MonthDays[7] := 31;
  MonthDays[8] := 31;
  MonthDays[9] := 30;
  MonthDays[10] := 31;
  MonthDays[11] := 30;
  MonthDays[12] := 31;
  for month := 1 to 12 do
    begin
      if days > MonthDays[month] then
        days := days - MonthDays[month]
      else
        break;
    end;
  if (year <> dosYear) or
     (month <> integer(dosMonth)) or
     (days <> integer(dosDay)) then
    begin
      dosYear := year;
      dosMonth := char(month);
      dosDay := char(days);
      asm { set the date through dos services }
        mov cx,dosYear
        add cx,1900
        mov dh,dosMonth
        mov dl,dosDay
        mov ah,2bh
        int 21h
        mov dosStatus,al
      end;
    end;
    Edit2.Text := copy('  JanFebMarAprMayJunJulAugSepOctNovDec',month*3,3) +
      ' ' + IntToStr(days) + ' ,19' + IntToStr(year);
end;

procedure Ttimefrm.Sockets1SessionClosed(Sender: TObject; Socket: Word);
begin
  Sockets1.SClose;
end;

procedure Ttimefrm.Sockets1SessionConnected(Sender: TObject; Socket: Word);
begin
  Sockets1.Text := 'time';
end;

end.
