program TestBigArray;

{$ifdef Windows}
uses WinDos, WinCrt, WinTypes, WinProcs, BigArray;
{$else}
uses Dos, Crt, WinAPI, BigArray;
{$endif}

const
  elnum = 2000;
type
  TRec = record
    i : integer;
    r : real;
    s : string;
    a : array[0..3000] of char;
  end;

var
  Rec : TRec;
  BArray : PBigArray;
  X : longint;
begin

  clrscr;

  writeln('memory available = ', memavail);

  new(BArray, Init(elnum, SizeOf(TRec)));

  for x := 0 to elnum-1 do begin
    Rec.i := x;
    BArray^.PutData(Rec, x);
  end;

  for x := elnum-1 downto 0 do begin
    BArray^.GetData(Rec, x);
    if x <> Rec.i then
      writeln(Rec.i);
  end;

  writeln('first size of mem for array = ', BArray^.GetMemSize);

{  BArray^.Resize(20000);

  for x := 10000 to 19999 do begin
    Rec.i := x;
    BArray^.PutData(Rec, x);
  end;

  for x := 19999 downto 0 do begin
    BArray^.GetData(Rec, x);
    writeln(Rec.i);
  end;

  writeln('second size of mem for array = ', BArray^.GetMemSize);
}
  dispose(BArray, Done);
  readln;
end.
