{*****************************************************************************}
{* Author : Andrew Phillips                                                  *}
{* Date   : 9-25-1989                                                        *}
{*                                                                           *}
{* Program: COLORS.PAS   A unit designed to build a color selection menu.    *}
{*****************************************************************************}

UNIT Colors;

INTERFACE

USES TpMOUSE,TpWINDOW,TpCRT;

    PROCEDURE ColorMenu (X, Y: byte;
                         UseExplode,UseSound,UseShadow : boolean;
                     VAR Color : Byte;
                     VAR ChangeColor : boolean);

IMPLEMENTATION

PROCEDURE GotoMouse;

    BEGIN

         GotoXY(MouseWhereX,MouseWhereY);

    END;

PROCEDURE Display_Error(error : word);

    BEGIN

         CASE Error OF

              1 : writeln ('Menu cannot be made.');
              2 : writeln ('Menu cannot be displayed.');

              END;

         Exit

    END;


PROCEDURE Get_Color(VAR Color : byte);

    BEGIN

         Color := ReadAttrAtCursor

    END;

PROCEDURE Left_Arrow;

    BEGIN

         GotoMouse;
         GotoXY(WhereX-1,WhereY);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Right_Arrow;

    BEGIN

         GotoMouse;
         GotoXY(WhereX+1,WhereY);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Up_Arrow;

    BEGIN

         GotoMouse;
         GotoXY(WhereX,WhereY-1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Down_Arrow;

    BEGIN

         GotoMouse;
         GotoXY(WhereX, WhereY+1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Home_Key;

    BEGIN

         GotoMouse;
         GotoXY(WhereX-1,WhereY-1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Pg_Up;

    BEGIN

         GotoMouse;
         GotoXY(WhereX+1,WhereY-1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE End_Key;

    BEGIN

         GotoMouse;
         GotoXY(WhereX-1,WhereY+1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE Pg_Dn;

    BEGIN

         GotoMouse;
         GotoXY(WhereX+1,WhereY+1);
         IF MouseInstalled THEN MouseGotoXY(WhereX,WhereY)

    END;

PROCEDURE ColorMenu (
         X, Y: byte;
				 UseExplode,UseSound,UseShadow : boolean;
         VAR Color : Byte; VAR ChangeColor : boolean);

    LABEL
         Here, There;

    CONST
         MouseLeft    = 239;
         MouseRight   = 238;
         UpArrow      = 72;
         DownArrow    = 80;
         LeftArrow    = 75;
         RightArrow   = 77;
         CR           = 13;
         SPC          = 32;
         ESC          = 27;
         HOME         = 71;
         ENDKEY       = 79;
         PgUP         = 73;
         PgDN         = 81;

    VAR
         xy,scan : word;
         Colors  : WindowPtr;
         i, j    : byte;
         backg   : byte;
         FOReg   : Byte;
         Attr    : Byte;
         Code    : Word;
         HiCode  : Byte;
         LoCode  : Byte;

    BEGIN

         GetCursorState(XY,scan);
         IF MouseInstalled THEN
         EnableEventHandling;          {Activate Mouse               }
         HiddenCursor;                 {Turn off Hardware Cursor     }


   {Make the Window}

         IF (X+16 > 80) or (Y+8>25) or (X < 1) or (X < 1) THEN

              BEGIN

                   X := 1;
                   Y := 1;

              END;

         Explode    := UseExplode;
         Shadow     := UseShadow;
         SoundFlagW := UseSound;
         ShadowAttr := $07;

         IF not MakeWindow(
              Colors,
              X,Y,X+17,Y+9,
              True,True,False,
              $0E,$0E,$0E,
              'Colors'   )           THEN Display_Error(1); {Cannot Make   }

         IF not DisplayWindow(Colors)  THEN Display_Error(2); {Cannot Display}

         FOR backg := 0 to 7 DO
         FOR Foreg := 0 to 15 DO

              BEGIN

                   Attr := ((backg*16)+Foreg);
                   FastWriteWindow(#4,backg+1,Foreg+1,attr)

              END;

         IF MouseInstalled THEN

              BEGIN

                   SetMickeyToPixelRatio(16,32) ;
                   MouseWindow(x+1,y+1,x+16,y+8);
                   SoftMouseCursor($FF00,$0008) ;     {Set Mouse Cursor}
                   ShowMouse;

              {Scan Mouse and Keyboard for Input}

              There:
                   GotoXY(MouseWhereX,MouseWhereY);

                   Code   := ReadKeyOrButton;
                   LoCode := Lo(Code);
                   HiCode := Hi(Code);

                   IF LoCode = 0 THEN

                        CASE HiCode OF

                             CR      : ChangeColor := True;
                             ESC     : ChangeColor := False;
                             SPC     : ChangeColor := True;

                             UpArrow : BEGIN

                                            Up_Arrow;
                                            GOTO There

                                       END;

                           LeftArrow : BEGIN

                                            Left_Arrow;
                                            GOTO There

                                       END;

                          RightArrow : BEGIN

                                            Right_Arrow;
                                            GOTO There
                                       END;

                           DownArrow : BEGIN

                                            Down_Arrow;
                                            GOTO There

                                       END;
                                Home : BEGIN

                                            Home_Key;
                                            GOTO There
                                       END;

                              ENDKEY : BEGIN

                                            End_Key;
                                            GOTO There

                                       END;

                                PgUp : BEGIN

                                            Pg_Up;
                                            GOTO There

                                       END;

                                PgDn : BEGIN

                                            Pg_Dn;
                                            GOTO There

                                       END;

                           MouseLeft : BEGIN

                                            GotoXY(MouseWhereX,MouseWhereY);
                                            ChangeColor := True;

                                       END;

                          MouseRight : ChangeColor := False

                   ELSE

                         CASE LoCode OF

                                  CR : ChangeColor := True;
                                 ESC : ChangeColor := False;
                                 SPC : ChangeColor := True;
                              0..255 : GOTO There
                         END
                   END

         ELSE

              CASE LoCode OF

                       CR : ChangeColor := True;
                      ESC : ChangeColor := False;
                      SPC : ChangeColor := True;
                   1..255 : GOTO There
              END;

         GotoMouse;
         Color := ReadAttrAtCursor;
    END

		{No Mouse, so just scan keyboard}

    ELSE
         BEGIN
              Here:
                   Code := ReadKeyWord;
                   LoCode := Lo(Code);
                   HiCode := Hi(Code);

                   IF LoCode = 0 THEN

                        CASE HiCode OF

                                 CR : ChangeColor := True;
                                ESC : ChangeColor := False;
                                SPC : ChangeColor := True;

                            UpArrow : BEGIN

                                           Up_Arrow;
                                           GOTO There

                                      END;

                          LeftArrow : BEGIN

                                           Left_Arrow;
                                           GOTO There

                                      END;

                         RightArrow : BEGIN

                                           Right_Arrow;
                                           GOTO There

                                      END;

                          DownArrow : BEGIN

                                           Down_Arrow;
                                           GOTO There

                                      END;

                               Home : BEGIN

                                           Home_Key;
                                           GOTO There

                                      END;

                             EndKey : BEGIN

                                           End_Key;
                                           GOTO There

                                      END;

                               PgUp : BEGIN

                                           Pg_Up;
                                           GOTO There

                                      END;

                               PgDn : BEGIN

                                           Pg_Dn;
                                           GOTO There

                                      END

                   ELSE
                        CASE LoCode OF

                                 CR : ChangeColor := True;
                                ESC : ChangeColor := False;
                                SPC : ChangeColor := True;
                             1..255 : GOTO Here;

                        END

                   END

              ELSE
                   CASE LoCode OF

                            CR : ChangeColor := True;
                           ESC : ChangeColor := False;
                           SPC : ChangeColor := True;
                        1..255 : GOTO There

                   END;

              GotoMouse;
              Color := ReadAttrAtCursor;

         END;

     {Finish Up Program}

         HideMouse;
         DisableEventHandling;    {De-Activate Mouse to avoid "Mouse Droppings"}
         DisposeWindow(
              EraseTopWindow);    {Get rid of window}
         RestoreCursorState(
              XY,scan);           {Reset Hardware Cursor}

    END;

END.
