{*****************************************************************************}
{* Author : Andrew Phillips                                                  *}
{* Date   : 9-25-1989                                                        *}
{*                                                                           *}
{* Program: COLORT.PAS   An example program implementing the COLORS.TPU unit *}
{*****************************************************************************}

PROGRAM Test_Menu_Colors;

USES
    Colors;

CONST
    UseExplode = True;  {Make menu explode when opened, implode when closed.  } 
    UseSound   = True;  {Make noise while exploding and imploding.            }
    UseShadow  = True;  {Put a shadow underneath menu to simulate 3-D.        }

VAR
    Color  : byte;      {Upon exit this contains the attribute selected.      }
    Change : boolean;   {This indicates if the change was entered or aborted. }
    Row    : byte;      {This is the top left Y coordinate for menu           }
    Column : byte;      {This is the top left X coordinate for menu           }

BEGIN

    Row    :=  4;       {First row of menu}
    Column := 35;       {First column of menu}
                        {If Row and Column would put menu past bottom right
                         corner of screen, they will be forced to (1,1)       }

    ColorMenu(
         Row,Column,                                     
         UseExplode,UseSound,UseShadow,     
         Color,                            
         Change
             );

    IF Change THEN
         writeln ('Color Selected: ',Color)
    ELSE
         writeln ('No Color Change');


END.
