Program xx;
{Exercise contour plotting routines}
{$R+}

Type
  ValueGrid = Array[1..50,1..50] of real;
  ContourArray = Array[1..100] of real;
  Screenline = String[80];

Const
  k = 1;

Var
  XDiv, YDiv, NoOfContours, i, j: integer;
  XLow, XHigh, Ylow, YHigh, x, y: real;
  Value: ValueGrid;
  ContourValues: ContourArray;




  Function Min(x,y: Real) : Real;
  {Minimum of two reals}
  Begin
    If x<y then Min := x else Min := y;
  End;



  Function Max(x,y: Real) : Real;
  {Maximum of two reals}
  Begin
    If x>y then Max := x else Max := y;
  End;









Procedure Contour(Xlow, Xhigh, Ylow, Yhigh: real;
                  XDiv, YDiv, NoOfContours: Integer;
                  Value:ValueGrid;
                  ContourValues: ContourArray; title:Screenline);
Const
  WindowXLow = 60;
  WindowYLow = 10;
  WindowXHigh= 629;
  WindowYHigh= 189;
Var
  i, ix, iy, width, height, TitleLength, XZero, YZero : integer;
  SquareWidth, SquareHeight: real;


Procedure DrawContours(ix,iy: Integer);
{Draw all the contours in the square whose upper left corner is ix,iy}
Var
  LPoint, RPoint, UPoint, DPoint, IContour, x1, y1, x2, y2: Integer;
  ULVal, URVal, LLVal, LRVal, MinVal, MaxVal, CVal, Frac: Real;
Begin

  {Determine screencoordinates of square corners}
  {  (remember that y and iy increase upwards, not downwards) }
  LPoint := Round(Int(ix-1) * SquareWidth);
  RPoint := Round(Int(ix) * SquareWidth);
  UPoint := Round(Height - Int(iy) * SquareHeight);
  DPoint := Round(Height - Int(iy-1) * SquareHeight);

  {Set up values of corners}
  ULVal := Value[ix,iy+1];
  URVal := Value[ix+1,iy+1];
  LRVal := Value[ix+1,iy];
  LLVal := Value[ix,iy];

  {Determine min and max values on this square}
  MinVal := Min(ULVal, Min(URVal, Min(LRVal,LLVal)));
  MaxVal := Max(ULVal, Max(URVal, Max(LRVal,LLVal)));

  {Loop over contours}
  If ContourValues[NoOfContours] > MinVal then
  Begin
    IContour := 1;
    While ContourValues[IContour] < MinVal do IContour:=IContour+1;
    CVal := ContourValues[IContour];
    While (CVal < MaxVal) and (IContour<=NoOfContours) do
    Begin

      {Left Side}
      If (CVal < Max(ULVal,LLVal)) and (CVal > Min(ULVal,LLVal)) then
      Begin
        x1 := LPoint;
        y1 := UPoint + Round(SquareHeight*(CVal-ULVal)/(LLVal-ULVal));
        If (CVal < Max(LLVal,LRVal)) and (CVal > Min(LLVal,LRVal)) then
        {Join to Bottom}
        Begin
          x2 := LPoint + Round(SquareWidth*(CVal-LLVal)/(LRVal-LLVal));
          y2 := DPoint;
        End
        Else
        {Join to Diagonal}
        Begin
          Frac := (CVal-ULVal)/(LRVal-ULVal);
          x2 := LPoint + Round(SquareWidth*Frac);
          y2 := UPoint + Round(SquareHeight*Frac);
        End;
        Draw(x1,y1,x2,y2,White);
        Plot(x2,y2,White);
      End
      Else
      Begin
      {Bottom}
        If (CVal < Max(LLVal,LRVal)) and (CVal > Min(LLVal,LRVal)) then
        Begin
          x1 := LPoint + Round(SquareWidth*(CVal-LLVal)/(LRVal-LLVal));
          y1 := DPoint;
          {Join to Diagonal}
          Frac := (CVal-ULVal)/(LRVal-ULVal);
          x2 := LPoint + Round(SquareWidth*Frac);
          y2 := UPoint + Round(SquareHeight*Frac);
          Draw(x1,y1,x2,y2,White);
          Plot(x2,y2,White);
        End;
      End;

      {Right Side}
      If (CVal < Max(URVal,LRVal)) and (CVal > Min(URVal,LRVal)) then
      Begin
        x1 := RPoint;
        y1 := UPoint + Round(SquareHeight*(CVal-URVal)/(LRVal-URVal));
        If (CVal < Max(ULVal,URVal)) and (CVal > Min(ULVal,URVal)) then
        {Join to Top}
        Begin
          x2 := LPoint + Round(SquareWidth*(CVal-ULVal)/(URVal-ULVal));
          y2 := UPoint;
        End;
        {Else join to Diagonal (note that (x2,y2) are the same as before)}
        Draw(x1,y1,x2,y2,White);
      End
      Else
      Begin
      {Top}
        If (CVal < Max(ULVal,URVal)) and (CVal > Min(ULVal,URVal)) then
        Begin
          x1 := LPoint + Round(SquareWidth*(CVal-ULVal)/(URVal-ULVal));
          y1 := UPoint;
          {Join to Diagonal (note that (x2,y2) are the same as before)}
          Draw(x1,y1,x2,y2,White);
        End;
      End;

      IContour := IContour + 1;
      CVal := ContourValues[IContour];
    End;
  End;

End; {of DrawContours}

Begin {Contour}

  {Draw box around graph}
  Width := WindowXHigh - WindowXLow;
  Height := WindowYHigh - WindowYLow;
  Hires;
  HiresColor(White);
  Graphwindow(WindowXLow, WindowYLow, WindowXHigh, WindowYHigh);
  Draw(0,0, width,0, White);
  Draw(width,0, width,height, White);
  Draw(width,height, 0,height, White);
  Draw(0,height, 0,0, White);

  {Write the title}
  TitleLength := Length(Title);
  GotoXY(40-TitleLength div 2,1);
  Write(Title);

  {Label axes}
  GotoXY(4,24);
  Write(xlow:4);
  GotoXY(2,24);
  Write(ylow:4);
  GotoXY(72,24);
  Write(xhigh:4);
  GotoXY(2,3);
  Write(yhigh:4);

  {If zero is on the plot, draw a line through it}
  If (XLow<0) and (XHigh>0) then
  Begin
    XZero := Round(-XLow*Width/(XHigh-XLow));
    Draw(XZero, 0, XZero, Height, White);
  End;
  If (YLow<0) and (YHigh>0) then
  Begin
    YZero := Round(YHigh*Height/(YHigh-YLow));
    Draw(0, YZero, Width, YZero, White);
  End;

  {Set up factors}
  SquareWidth := (WindowXHigh - WindowXLow) / Int(XDiv-1);
  SquareHeight := (WindowYHigh - WindowYLow) / Int(YDiv-1);

  {Loop over squares, drawing contours in each}
  For ix := 1 to XDiv-1 do
  Begin
    For iy := 1 to YDiv-1 do
    Begin
      DrawContours(ix, iy);
    End;
  End;

End; {of Contour}


{ Start main program }
{ ------------------ }
Begin
  Writeln('Calculating points');
  NoOfContours := 30;
  For i:= 1 to NoOfContours do ContourValues[i]:=0.5*i;
  XLow := -6;
  XHigh := 10;
  YLow := -6;
  YHigh := 10;
  XDiv := 15;
  YDiv := 15;
  For i := 1 to XDiv do
  Begin
    For j := 1 to YDiv do
    Begin
      x := XLow + (XHigh-XLow)*Int(i-1)/Int(Xdiv-1);
      y := YLow + (YHigh-YLow)*Int(j-1)/Int(Ydiv-1);
      Value[i,j] := 0.1 * (Sqr(x) + Sqr(y));
    End;
  End;
  Writeln('All points calculated');
  Contour(Xlow, XHigh, YLow, YHigh, XDiv, YDiv, NoOfContours,
    Value, ContourValues, 'Test1');
End.
                    