/*
VALIDCRC.C

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

November 16, 1990

	This module validates the CRC of the program in which it is linked.
The code was designed as an anti-virus algorithm.  The CRC is a very effective
method of detecting viruses; any virus that attaches itself to the program
changes the CRC of the program.  The response to an invalid CRC is entirely up
to the programmer.

	This code is public domain.
*/


#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#include "viruscrc.h"


/* Macros to extract low and high bytes of a word. */
#define lowb(x)  (*(unsigned char *)&(x))
#define hib(x)   (*((unsigned char *)&(x) + 1))

/* Macros to extract low and high words of a dword. */
#define loww(x)  (*(unsigned short *)&(x))
#define hiw(x)   (*((unsigned short *)&(x) + 1))


/***/
/* Calculate CRC of active program and compare it to CRC in _viruscrc. */
int isvalidcrc(const char *progname)
{
char buffer[1024];		/* Buffer for file's data. */
crc32_t table[256];		/* CRC table. */
int valid;			/* Validity of CRC. */
register size_t i;		/* Byte counter. */
register crc32_t *halfi;	/* Pointer to CRC of i / 2. */
crc32_t crc;			/* Current CRC. */
FILE *progfile;			/* Program file. */
char *bufptr;			/* Pointer to buffer. */
char *pn;			/* Pointer to program name. */

if (_osmajor < 3)
  /* Search PATH for program file. */
  pn = searchpath(progname);
else
  /* Under DOS versions 3 and above, the program name is in _argv[0]. */
  pn = _argv[0];

if (_viruscrc.x.polynomial != 0)
  if ((progfile = fopen(pn, "rb")) != NULL)
    {
    /* Generate a CRC lookup table for faster calculation. */
    for (i = 0, halfi = table, table[0] = 0; i < 256; i += 2, halfi++)
      if (hib(hiw(*halfi)) & 0x80)
	table[i] = (table[i + 1] = *halfi << 1) ^ _viruscrc.x.polynomial;
      else
	table[i + 1] = (table[i] = *halfi << 1) ^ _viruscrc.x.polynomial;

    crc = 0;
    while ((i = fread(buffer, 1, sizeof(buffer), progfile)) != 0)
      for (bufptr = buffer; i--; bufptr++)
	crc = (crc << 8) ^ table[hib(hiw(crc)) ^ *bufptr];

    fclose(progfile);

    valid = crc == _viruscrc.x.crc;
    }
  else
    /* If unable to open program file, assume CRC is invalid. */
    valid = 0;
else
  /* CRC polynomial must be something other than 0. */
  valid = 0;

return (valid);
}