{$I-}
{
VALIDCRC.PAS

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

November 16, 1990

	This module validates the CRC of the program in which it is linked.
The code was designed as an anti-virus algorithm.  The CRC is a very effective
method of detecting viruses; any virus that attaches itself to the program
changes the CRC of the program.  The response to an invalid CRC is entirely up
to the programmer.

	This code is public domain.
}


unit ValidCRC;


interface


uses
  DOS;


type
  crc32_t =
    longint;

  FileCRC =
    record
    case boolean of
      false:
	(
	SearchStr : array [1 .. 8] of char;	{ String to search for. }
	);

      true:
	(
	Polynomial : crc32_t;			{ Polynomial for this file. }
	CRC : crc32_t;				{ Calculated CRC for this file. }
	)
    end;


function IsValidCRC(ProgName : string) : boolean;


implementation


const _VirusCRC : FileCRC =
  (
  SearchStr : ('D', 'E', 'A', 'N', '_', 'C', 'R', 'C')
  );


type
  dwordrec =
    record
    Lo, Hi : word
    end;


{***}
{ Extract the low word of a dword. }
function LowW(dword : longint) : word;

begin
LowW := (dwordrec(dword)).Lo
end;


{***}
{ Extract the high word of a dword. }
function HiW(dword : longint) : word;

begin
HiW := (dwordrec(dword)).Hi
end;


{***}
{ Calculate CRC of active program and compare it to CRC in _VirusCRC. }
function IsValidCRC(ProgName : string) : boolean;

var
  PN : string;				{ Program name. }
  Buffer : array [1 .. 1024] of byte;	{ Buffer for file's data. }
  Table : array [0 .. 255] of crc32_t;	{ CRC table. }
  I : word;				{ Byte counter. }
  HalfI : ^crc32_t;			{ Pointer to CRC of I div 2. }
  CRC : crc32_t;			{ Current CRC. }
  ProgFile : file;			{ Program file. }
  BufPtr : ^byte;			{ Pointer to Buffer. }

begin
if Lo(DosVersion) < 3 then
  { Search PATH for program file. }
  PN := FSearch(ProgName, GetEnv('PATH'))
else
  { Under DOS versions 3 and above, the program name is in ParamStr(0). }
  PN := ParamStr(0);

if _VirusCRC.Polynomial <> 0 then
  begin
  Assign(ProgFile, PN);
  Reset(ProgFile, 1);

  if IOResult = 0 then
    begin
    { Generate a CRC lookup table for faster calculation. }
    HalfI := @Table[0];
    Table[0] := 0;
    I := 0;
    while I < 256 do
      begin
      if Hi(HiW(HalfI^)) and $80 = $80 then
	begin
	Table[I + 1] := HalfI^ shl 1;
	Table[I] := Table[I + 1] xor _VirusCRC.Polynomial
	end
      else
	begin
	Table[I] := HalfI^ shl 1;
	Table[I + 1] := Table[I] xor _VirusCRC.Polynomial
	end;

      Inc(I, 2);
      Inc(longint(HalfI), sizeof(crc32_t))
      end;

    CRC := 0;
    BlockRead(ProgFile, Buffer, sizeof(Buffer), I);
    while I <> 0 do
      begin
      BufPtr := @Buffer[1];
      while I <> 0 do
	begin
	CRC := (CRC shl 8) xor Table[Hi(HiW(CRC)) xor BufPtr^];

	Dec(I);
	Inc(longint(BufPtr))
	end;

      BlockRead(ProgFile, Buffer, sizeof(Buffer), I)
      end;

    Close(ProgFile);
    IsValidCRC := CRC = _VirusCRC.CRC
    end
  else
    { If unable to open program file, assume CRC is invalid. }
    IsValidCRC := false
  end
else
  { CRC polynomial must be something other than 0. }
  IsValidCRC := false
end;


end.