{ ----------------------------------------------------------------------
  DFStr.INC - string functions for Turbo Pascal

  Written 1991 by:

  David Firth                           GEnie: D.FIRTH
  5665 A2 Parkville Ct.                   CIS: 76467,1734
  Columbus, OH 43229
  (614) 523-1968

  Revision 0: May 1991 - __JustStr & __RemWhiteStr

  These routines will work with any version of turbo, but as the
  include file designation states, I wrote these for my venerable
  version 3 compiler.  I own TP5.5 and have TP6 registered to me
  at work, but for running TP out of a ram disk when I'm out in
  the field, nothing beats my old TP3.
  ---------------------------------------------------------------------- }

Type

  AnyStr = string[255];
  Str8   = string[8];

Const

  _LeftJustify  : byte = 0;               {__JustStr}
  _RightJustify : byte = 1;               {__JustStr}
  _Leading      : byte = 0;               {__RemWhiteStr}
  _Trailing     : byte = 1;               {__RemWhiteStr}
  _All          : byte = 2;               {__RemWhiteStr}

{ ------------------------ PROCEDURES/FUNCTIONS ----------------------- }

Function __JustStr(InputStr:AnyStr;
                   Len:byte;
                   JustChar:char;
                   JustMode:byte) : AnyStr;

{ Justify string is a very useful function for padding strings. After
  the first time I used a justify function, I had to hae one for TP3.

  InputStr is the string to pad.

  Len is the length that the final string needs to be.

  JustChar is the character to pad by.

  JustMode is a constant, chosen from the list above, which chooses
  whether the string is left or right justified.
}

Var

  Count,                                   {general purpose counter         }
  NumChars   : byte;                       {number of characters to pad with}

Begin

  if Length(InputStr) < Len then begin

    NumChars := Len - Length(InputStr);
    for Count := 1 to NumChars do begin
      case JustMode of
        0: InputStr := InputStr + JustChar;
        1: InputStr := JustChar + InputStr;
      end; {case}
    end; {for}

  end
  else begin

    InputStr := Copy(InputStr,1,Len);

  end; {if-else}

  __JustStr := InputStr;

End; {__JustStr}

{ --------------------------------------------------------------------- }

Function __RemWhiteStr(InputStr:AnyStr;MyMode:byte):AnyStr;

{ This function is useful for stripping spaces from a string.

  InputStr is the string that will be processed.

  MyMode is a constant, chosen from the list above, that chooses
  whether the leading, trailing, or entire complement of spaces
  is removed.
}

Var

  Count : byte;                   {general purpose counter}
  MyStr : AnyStr;                 {temporary string       }

begin

  if (MyMode=_Leading) then begin
    {remove the leading spaces}
    Count := 0;
    while (InputStr[Count+1]=' ') AND (Count<Length(InputStr)) do begin
      Count := Count + 1;
    end; {while}
    if Count > 0 then
      Delete(InputStr,1,Count);
  end; {if}

  if (MyMode=_Trailing) then begin
    {remove the leading spaces}
    Count := Length(InputStr);
    while (InputStr[Count]=' ') AND (Count>0) do begin
      Count := Count - 1;
    end; {while}
    if Count < Length(InputStr) then
      Delete(InputStr,Count+1,Length(InputStr)-Count);
  end; {if}

  if (MyMode=_All) then begin
    MyStr := '';
    for Count := 1 to Length(InputStr) do begin
      if InputStr[Count] <> ' ' then
        MyStr := MyStr + InputStr[Count];
    end; {for}
    InputStr := MyStr;
  end; {if}

  __RemWhiteStr := InputStr;

end; {__RemWhiteStr}

