//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  NON-LOCAL GOTO (ANSI and POSIX)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#define _JBLEN  9  /* bp, di, si, sp, ret addr, ds */

#ifndef _JMP_BUF_DEFINED
typedef  int  jmp_buf[_JBLEN];
#define _JMP_BUF_DEFINED
#endif

#if _POSIX1_SOURCE > 0

#ifndef _SIGJMP_BUF_DEFINED
typedef  struct {
    jmp_buf env ;
    _Sigmask_t  mask ;
} sigjmp_buf;
#define _SIGJMP_BUF_DEFINED
#endif

#endif

extern "C" {

int     _CDECL  setjmp  (jmp_buf) ;
void    _CDECL  longjmp (jmp_buf, int) ;

#if _POSIX1_SOURCE > 0
int     _CDECL  sigsetjmp   (sigjmp_buf, int) ;
int     _CDECL  siglongjmp  (sigjmp_buf, int) ;
#endif

}
