//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  STRING ROUTINES (ANSI)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#if !defined(__STRING_H_INCLUDED)

#define NULL    _NULL

#ifndef _SIZE_T_DEFINED
typedef _Size_t size_t;
#define _SIZE_T_DEFINED
#endif

extern "C" {

void *  _CDECL  memchr      (const void *, int, size_t);
int     _CDECL  memcmp      (const void *, const void *, size_t);
void *  _CDECL  memcpy      (void *, const void *, size_t);
void *  _CDECL  memmove     (void *, const void *, size_t);
void *  _CDECL  memset      (void *, int, size_t);

char *  _CDECL  strcat      (char *, const char *);
char *  _CDECL  strchr      (const char *, int);
int     _CDECL  strcmp      (const char *, const char *);
int     _CDECL  strcoll     (const char *, const char *);
char *  _CDECL  strcpy      (char *, const char *);
size_t  _CDECL  strcspn     (const char *, const char *);
char *  _CDECL  strerror    (int);
size_t  _CDECL  strlen      (const char *);
char *  _CDECL  strncat     (char *, const char *, size_t);
int     _CDECL  strncmp     (const char *, const char *, size_t);
char *  _CDECL  strncpy     (char *, const char *, size_t);
char *  _CDECL  strpbrk     (const char *, const char *);
char *  _CDECL  strrchr     (const char *, int);
size_t  _CDECL  strspn      (const char *, const char *);
char *  _CDECL  strstr      (const char *, const char *);
char *  _CDECL  strtok      (char *, const char *);
size_t  _CDECL  strxfrm     (char *, const char *, size_t);

/* ************************************************************************ *\
 * These names are not really in the correct namespace for this header.     *
 *                                                                          *
 * The standard ANSI library code may not rely on these names being present *
 * either as macros or as functions, or them performing any set action.     *
\* ************************************************************************ */

//
//	FAR versions of some popular string routines
//
void _far *	_CDECL _far	_fmemchr      (const void _far *, int, size_t);
int  		_CDECL _far	_fmemcmp      (const void _far *, const void _far *, size_t);
void _far *	_CDECL _far	_fmemcpy      (void _far *, const void _far *, size_t);
void _far *	_CDECL _far	_fmemmove     (void _far *, const void _far *, size_t);
void _far *	_CDECL _far	_fmemset      (void _far *, int, size_t);

char _far *	_CDECL _far	_fstrcat      (char _far *, const char _far *);
char _far *	_CDECL _far	_fstrchr      (const char _far *, int);
int			_CDECL _far	_fstrcmp      (const char _far *, const char _far *);
int			_CDECL _far	_fstrcoll     (const char _far *, const char _far *);
char _far *	_CDECL _far	_fstrcpy      (char _far *, const char _far *);
size_t		_CDECL _far	_fstrcspn     (const char _far *, const char _far *);
char _far *	_CDECL _far	_fstrerror    (int);
size_t		_CDECL _far	_fstrlen      (const char _far *);
char _far *	_CDECL _far	_fstrncat     (char _far *, const char _far *, size_t);
int			_CDECL _far	_fstrncmp     (const char _far *, const char _far *, size_t);
char _far *	_CDECL _far	_fstrncpy     (char _far *, const char _far *, size_t);
char _far *	_CDECL _far	_fstrpbrk     (const char _far *, const char _far *);
char _far *	_CDECL _far	_fstrrchr     (const char _far *, int);
size_t		_CDECL _far	_fstrspn      (const char _far *, const char _far *);
char _far *	_CDECL _far	_fstrstr      (const char _far *, const char _far *);
char _far *	_CDECL _far	_fstrtok      (char _far *, const char _far *);
size_t		_CDECL _far	_fstrxfrm     (char _far *, const char _far *, size_t);

/* ************************************************************************ *\
 * These names reserved in the namespace for "future use" by this header.   *
 *                                                                          *
 * The standard ANSI library code may not rely on these names being present *
 * either as macros or as functions, or them performing any set action.     *
\* ************************************************************************ */

//
// Defined for **IX compatibility
//
void *  _CDECL  memccpy     (void *, const void *, int, unsigned int);
int     _CDECL  memicmp     (const void *, const void *, unsigned int);
void    _CDECL  movedata    (unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);

int     _CDECL  strcmpi     (const char *, const char *);
char *  _CDECL  strdup      (const char *);
int     _CDECL  stricmp     (const char *, const char *);
char *  _CDECL  strlwr      (char *);
int     _CDECL  strncmpi    (const char *, const char *, size_t);
int     _CDECL  strnicmp    (const char *, const char *, size_t);
char *  _CDECL  strnset     (char *, int, size_t);
char *  _CDECL  strrev      (char *);
char *  _CDECL  strset      (char *, int);
char *  _CDECL  strupr      (char *);
/*char *    _CDECL  _strerror   (char *); */

//
// Additions to **IX string library
//
void *  _CDECL  memrchr     (const void *, int, size_t) ;
int     _CDECL  strblank    (const char *);
char *  _CDECL  strbmatch   (const char *, const char **);
int     _CDECL  strchg      (char *, char, char);
char *  _CDECL  strdel      (char *, const char *);
char *  _CDECL  strdela     (char *, const char *);
char *  _CDECL  strend      (const char *);
int     _CDECL  strichg     (char *, char, char);
char *  _CDECL  stridel     (char *, const char *);
char *  _CDECL  stridela    (char *, const char *);
char *  _CDECL  strins      (char *, const char *, size_t);
int     _CDECL  striocc     (const char *, char);
char *  _CDECL  strischg    (char *, const char *, const char *);
char *  _CDECL  stristr     (const char *, const char *);
char *  _CDECL  strisrep    (char *, const char *, const char *);
char *  _CDECL  strljust    (char *);
char *  _CDECL  strltrim    (char *);
int     _CDECL  strmatch    (const char *, const char *);
char *  _CDECL  strmid      (const char *, size_t, size_t);
char *  _CDECL  strndup     (const char *, size_t);
size_t  _CDECL  strnlen     (const char *, size_t);
int     _CDECL  strocc      (const char *, char);
char *  _CDECL  strrjust    (char *);
char *  _CDECL  strrol      (char *, size_t);
char *  _CDECL  strror      (char *, size_t);
char *  _CDECL  strrtrim    (char *);
char *  _CDECL  strschg     (char *, const char *, const char *);
char *  _CDECL  strsetsz    (char *, size_t);
char *  _CDECL  strshl      (char *, size_t);
char *  _CDECL  strshr      (char *, size_t);
int     _CDECL  strsocc     (const char *, const char *);
char *  _CDECL  strsrep     (char *, const char *, const char *);
char *  _CDECL  struplw     (char *);

#if _BSD_SOURCE > 0
char *  _CDECL  index       (const char *, int);
char *  _CDECL  rindex      (const char *, int);
char *  _CDECL  bcopy       (const char *, char *, size_t);
char *  _CDECL  bzero       (char *, size_t);
int     _CDECL  bcmp        (const char *, const char *, size_t);
#endif

#if __BORLANDC__
//
// Borland C uses a system whereby __double_underscore_functions__ are
// expanded to inline code by the compiler.
//
void *  _CDECL  __memchr__  (const void *, int, size_t);
int     _CDECL  __memcmp__  (const void *, const void *, size_t);
void *  _CDECL  __memcpy__  (void *, const void *, size_t);
void *  _CDECL  __memset__  (void *, int, size_t);
char *  _CDECL  __stpcpy__  (char *, const char *);
char *  _CDECL  __strcat__  (char *, const char *);
char *  _CDECL  __strchr__  (const char *, int);
int     _CDECL  __strcmp__  (const char *, const char *);
char *  _CDECL  __strcpy__  (char *, const char *);
size_t  _CDECL  __strlen__  (const char *);
char *  _CDECL  __strncat__ (char *, const char *, size_t);
int     _CDECL  __strncmp__ (const char *, const char *, size_t);
char *  _CDECL  __strncpy__ (char *, const char *, size_t);
char *  _CDECL  __strnset__ (char *, int, size_t);
char *  _CDECL  __strrchr__ (const char *, int);
char *  _CDECL  __strset__  (char *, int);
#endif

}

#define strcmpi(s,d)    stricmp(s,d)
#define strncmpi(s,d,n) strnicmp(s,d,n)

#if _BSD_SOURCE > 0
#       define index(s,c)   strchr(s,c)
#       define rindex(s,c)  strrchr(s,c)
#       define bcopy(s,d,c) strncpy(d,s,c)
#       define bzero(s,n)   memset(s,'\000',n)
#       define bcmp(d,s,n)  memcmp(d,s,n)
#endif

#define __STRING_H_INCLUDED
#endif
