Program OpenFileExample;

{$R openfile}

Uses WIN31, WINPROCS, WINTYPES, COMMDLG;

Var
  ofn : TOpenFileName;
  FileName : Array [0..255] Of Char;
  FileTitle : Array[0..12] Of Char;
  WM_FILEOK : Word;
  Icon : HIcon;

Const
  Filters : PChar = 'C source files (*.c)'+#0+'*.c'+#0+
                    'C++ source files (*.cpp)'+#0+'*.cpp'+#0+
                    'Pascal source files (*.pas)'+#0+'*.pas'+#0+
                    #0;

{ This is the hook function. In here we can trap messages sent to   }
{ the File Open dialog and process them before the normal code gets }
{ a chance. By returning anything other than 0, we can say to the   }
{ original procedure "I've processed this message, so you should    }
{ ignore it".                                                       }

Function FileOpenHook(Wnd : HWnd; Msg, wParam : Word; lParam : Longint) : Word; Export;

  { Dialogs don't normally have icons associated with them, so we    }
  { process this message ourselves in order to paint the icon. Note  }
  { that we only do this when the window is an icon - otherwise, we  }
  { let the normal processing continue.                              }

  Function WMPaint : Word;
  Var
    ps : TPaintStruct;
    dc : HDC;
  Begin
    WMPaint := 0;
    If IsIconic(Wnd) Then
    Begin
      dc := BeginPaint(Wnd, ps);
      SendMessage(Wnd, WM_ICONERASEBKGND, dc, 0);
      DrawIcon(dc, 0, 0, Icon);
      EndPaint(Wnd, ps);
      WMPaint := 1;
    End;
  End;

  { This message lets us know when the Ok button has been clicked. By  }
  { intercepting it and always returning 1 we can prevent the dialog   }
  { from closing. At this point, FileName now has the name of the file }
  { selected or typed by the user.                                     }

  Function WMFileOk : Word;
  Begin
    MessageBox(Wnd, FileName, 'Ok button clicked!', MB_OK+MB_ICONINFORMATION);
    WMFileOk := 1;
  End;

Begin
  Case Msg Of
    WM_PAINT         : FileOpenHook := WMPaint;
    WM_QUERYDRAGICON : FileOpenHook := Icon;
  Else
    If Msg = WM_FILEOK Then
      FileOpenHook := WMFileOk
    Else
      FileOpenHook := 0;
  End;
End;

Begin

  { First we must initialize the TOpenFileName structure used by GetOpenFileName. }

  With ofn Do
  Begin
    lStructSize := SizeOf(TOpenFileName);
    hwndOwner := 0;
    hInstance := System.HInstance;
    lpstrFilter := Filters;
    lpstrCustomFilter := Nil;
    nMaxCustFilter := 0;
    nFilterIndex := 0;
    lpstrFile := @FileName;
    nMaxFile := sizeof(FileName);
    lpstrFileTitle := @FileTitle;
    nMaxFileTitle := sizeof(FileTitle);
    lpstrInitialDir := Nil;
    lpstrTitle := 'File Open Example';
    Flags := OFN_HIDEREADONLY + OFN_PATHMUSTEXIST + OFN_ENABLETEMPLATE + OFN_ENABLEHOOK;
    lpstrDefExt := 'pas';
    lCustData := 0;
    lpfnHook := FileOpenHook;
    lpTemplateName := 'MAIN';
  End;

  { Now we get the value of the message that COMMDLG sends when the OK button }
  { is clicked.                                                               }

  WM_FILEOK := RegisterWindowMessage(FILEOKSTRING);

  { Get a handle to the application's icon. }

  Icon := LoadIcon(HInstance, 'MAIN');

  { And we're off to the races! }

  GetOpenFileName(ofn);

  DestroyIcon(Icon);
End.