Unit OopObjs;

{ OOPOBJS.PAS  Version 1.1 Copyright 1992 Scott D. Ramsay }

{  OOPOBJS.PAS is free! Go crazy. }
{  When I was learning Linked-List in High School, I thought that I'd only  }
{ need it in boring stuff like database programming.  Doubled linked-list,  }
{ is a great way to handle multiple objects for games.  Throw in some OOP   }
{ design and Volia!  Easy managable sprites.                                }
{  I give this code to Public Domain.  Use it as you see fit.  Just include }
{ the first comment line when distributing the source code, Thanks.         }

{  Changes from 1.0:                                                        }
{    Added new parameter in method checkhit.                                }
{          var item:pobj                                                    }
{      Is a pointer to the object which called the checkhit                 }

Interface

type
  plist   = ^tlist;
  PObjs   = ^TObjs;
  TObjs   = object
              nx,ny,                       { Sprite Position               }
              flp,                         { Sprite number (for animation) }
              nrx,                         { I forget what this does       }
              num_sprite,                  { Num of sprites per objects    }
              timeo,                       { How long this object lasts    }
              pointage     : integer;      { Score value (for gamers)      }
              mapcolor     : byte;         { Color for radar display       }
              id,                          { I forget this one too         }
              explo,                       { TRUE if the object is explodin}
              overshow     : boolean;      { See: PROCEDURE DRAWITEMS      }
              powner       : plist;        { The PLIST node which this     }
                                           {  object belongs               }
              constructor init(vx,vy:integer);
              procedure drawitemobject;virtual;
              procedure calcitemobject;virtual;
              function checkhit(hx,hy:integer;var item:pobjs):boolean;virtual;
              destructor done; virtual;
            end;
  PobjMov = ^TobjMov;
  TobjMov = object(TObjs)
              ndx,ndy : integer;
              constructor init(vx,vy,vdx,vdy:integer);
              procedure calcitemobject; virtual;
            end;
  tlist = record
            item      : pobjs;
            prev,next : plist;
          end;
  pkill = ^tkill;
  tkill = record
            tk   : plist;
            next : pkill;
          end;

procedure addp(var nkbeg,nkend,p:plist);
procedure deletep(var nkbeg,nkend,p:plist);
procedure calcitems(var nkbeg:plist);
procedure drawitems(var nkbeg:plist;over:boolean);
procedure add2kill_list(var kill:pkill;var i:plist);
procedure cleankill_list(var kill:pkill;var nkbeg,nkend:plist);
procedure clean_plist(var nkbeg,nkend:plist);

Implementation

procedure calcitems(var nkbeg:plist);
var
  p : plist;
begin
  p := nkbeg;
  while p<>nil do
    begin
      p^.item^.calcitemobject;
      p := p^.next;
    end;
end;


procedure drawitems(var nkbeg:plist;over:boolean);
{
  This procedure is usually called from:  (GMORPH.PAS)
     Tmorph.pre_map
     Tmorph.post_map
  The OVER flag tells when this object should be drawn.  Behind
   geomorph or infront of the geomorph.
}
var
  p : plist;
begin
  p := nkbeg;
  while p<>nil do
    begin
      if (p^.item^.overshow=over)
        then p^.item^.drawitemobject;
      p := p^.next;
    end;
end;


procedure clean_plist(var nkbeg,nkend:plist);
var
  p,p2 : plist;
begin
  p := nkbeg;
  while p<>nil do
    begin
      p2 := p;
      p := p^.next;
      dispose(p2^.item,done);
      dispose(p2);
    end;
  nkbeg := nil;
  nkend := nil;
end;


procedure addp(var nkbeg,nkend,p:plist);
begin
  p^.next := nil;
  if nkend=nil
    then
      begin
        nkbeg := p;
        nkend := p;
        p^.prev := nil;
      end
    else
      begin
        p^.prev := nkend;
        nkend^.next := p;
        nkend := p;
      end;
end;


procedure deletep(var nkbeg,nkend,p:plist);
begin
  if nkbeg=nkend
    then
      begin
        nkbeg := nil;
        nkend := nil;
      end
    else
  if nkbeg=p
    then
      begin
        nkbeg := nkbeg^.next;
        nkbeg^.prev := nil;
      end
    else
  if nkend=p
    then
      begin
        nkend := nkend^.prev;
        nkend^.next := nil;
      end
    else
      begin
        p^.next^.prev := p^.prev;
        p^.prev^.next := p^.next;
      end;
  dispose(p^.item,done);
  dispose(p);
end;


procedure cleankill_list(var kill:pkill;var nkbeg,nkend:plist);
var
  p,p2 : pkill;
begin
  p := kill;
  while p<>nil do
    begin
      p2 := p;
      p := p^.next;
      deletep(nkbeg,nkend,p2^.tk);
      dispose(p2);
    end;
  kill := nil;
end;


procedure add2kill_list(var kill:pkill;var i:plist);
var
  p : pkill;
begin
  new(p);
  p^.tk := i;
  p^.next := kill;
  kill := p
end;

(**) { Tobjs Methods }

constructor TObjs.init(vx,vy:integer);
begin
  nx := vx; ny := vy; num_sprite := 1;
  mapcolor := $fb; pointage := 0;
  flp := 0; overshow := false;
end;


destructor tobjs.done;
begin
end;


procedure tobjs.drawitemobject;
begin
  { i.e.
     fbitdraw(nx,ny,pic[flip]^);
  }
end;


procedure tobjs.calcitemobject;
begin
end;


function tobjs.checkhit(hx,hy:integer;var item:pobjs):boolean;
begin
end;

(**) { TobjMov methods }

constructor TobjMov.init(vx,vy,vdx,vdy:integer);
begin
  nx := vx; ny := vy; ndx := vdx; ndy := vdy;
  mapcolor := $fb; pointage := 0;
  flp := 0; overshow := false;
end;


procedure TobjMov.calcitemobject;
begin
 { These are just simple examples of what should go in the methods }
  inc(nx,ndx); inc(ny,ndy);
  flp := (flp+1)mod num_sprite;
end;

end.