{************************************************}
{                                                }
{   Turbo Pascal 6.0                             }
{   Turbo Vision Forms Demo                      }
{   Copyright (c) 1990 by Borland International  }
{                                                }
{************************************************}

unit GSV_Flds;

{$F+,O+,X+,S-,D+}

interface

uses Objects, Drivers, Dialogs,
     GSOB_Str;

type

  PdBInputLine = ^TdBInputLine;
  TdBInputLine = object(TInputLine)
    IsActive    : boolean;
    PrevData    : PString;
    FldLabel    : PLabel;
    constructor Init(var Bounds: TRect; AMaxLen: Integer);
    destructor  Done; virtual;
    function    Changed : boolean; virtual;
    function    DataSize : word; virtual;
    procedure   GetData(var Rec); virtual;
    procedure   SetData(var Rec); virtual;
    procedure   HandleEvent(var Event: TEvent); virtual;
    function    Valid(Command: Word): Boolean; virtual;
  end;

  PdBNumInputLine = ^TdBNumInputLine;
  TdBNumInputLine = object(TdBInputLine)
    procedure   SetData(var Rec); virtual;
    function    Valid(Command: Word): Boolean; virtual;
  end;

procedure RegisterFields;

const
  RdBInputLine: TStreamRec = (
     ObjType: 10061;
     VmtLink: Ofs(TypeOf(TdBInputLine)^);
     Load:    @TdBInputLine.Load;
     Store:   @TdBInputLine.Store
  );

implementation

uses Views, MsgBox;


procedure RegisterFields;
begin
  RegisterType(RdBInputLine);
end;


{ TdBInputLine }

constructor TdBInputLine.Init(var Bounds: TRect; AMaxLen: Integer);
begin
  TInputLine.Init(Bounds, AMaxLen);
  PrevData := nil;
  IsActive := false;
  FldLabel := nil;
end;

destructor TdBInputLine.Done;
begin
  if PrevData <> nil then DisposeStr(PrevData);
  TInputLine.Done;
end;

function TdBInputLine.Changed: Boolean;
begin
   if PrevData <> nil then Changed := Data^ <> PrevData^
      else Changed := Data^[0] <> #0;
end;

function TdBInputLine.DataSize : word;
begin
   DataSize := MaxLen;
end;

procedure TdBInputLine.GetData(var Rec);
begin
  string(Rec) := data^;
end;

procedure TdBInputLine.SetData(var Rec);
begin
  data^ := string(Rec);
  if PrevData <> nil then DisposeStr(PrevData);
  PrevData := NewStr(data^);
end;

procedure TdBInputLine.HandleEvent(var Event: TEvent);
begin
  TInputLine.HandleEvent(Event);
end;

function TdBInputLine.Valid(Command: Word): Boolean;
begin
  Valid := TInputLine.Valid(Command)
end;

procedure TdBNumInputLine.SetData(var Rec);
var
   s : string[64];
begin
  fillchar(s,sizeof(s),' ');
  s[0] := chr(MaxLen-length(string(rec)));
  data^ := s + string(Rec);
  if PrevData <> nil then DisposeStr(PrevData);
  PrevData := NewStr(data^);
end;

function TdBNumInputLine.Valid(Command: Word): Boolean;
var
  Code: Integer;
  Value: Real;
  Ok: Boolean;
begin
  Ok := True;
  if (Command <> cmCancel) and (Command <> cmValid) then
  begin
     val(data^,Value,Code);
     if Code <> 0 then
     begin
        MessageBox('Numeric value is required in this field',nil,
                    mfError + mfOkButton);
        SelectAll(True);
        Ok := False;
     end;
  end;
  if Ok then Valid := TdBInputLine.Valid(Command)
  else Valid := False;
end;


end.
