UNIT SmplStuf;
{-----------------------------------------------------------------------------
                             Item Selection Routines

       SmplStuf Copyright (c)  Richard F. Griffin

       14 April 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This unit handles routines to allow display of lists and selection
       of items from the list.  These routines are provided to show how
       GS_dBase units can be used in an application.  They are offered
       with no guarantee or technical support.

             -----   NOT FOR USE IN A WINDOWS ENVIRONMENT   -----

   Changes:

-----------------------------------------------------------------------------}

INTERFACE

USES
   Crt,
   Dos,
   GSOB_Inx,
   GSOB_Str,
   GSOB_Dte,
   GSOB_Var;

const
   BeepTime = 200;
   BeepFreq = 600;

   Kbd_Null = #0;                     {Null Character}
   Kbd_Nul  = #3;                     {Another Null}
   Kbd_Bsp  = #8;                     {Backspace}
   Kbd_Tab  = #9;                     {Tab}
   Kbd_Ret  = #13;                    {Return}
   Kbd_RTb  = #15;                    {Shift-Tab}
   Kbd_Esc  = #27;                    {Escape}
   Kbd_F1   = #59;                    {F1}
   Kbd_F2   = #60;                    {F2}
   Kbd_F3   = #61;                    {F3}
   Kbd_F4   = #62;                    {F4}
   Kbd_F5   = #63;                    {F5}
   Kbd_F6   = #64;                    {F6}
   Kbd_F7   = #65;                    {F7}
   Kbd_F8   = #66;                    {F8}
   Kbd_F9   = #67;                    {F9}
   Kbd_F10  = #68;                    {F10}
   Kbd_Home = #71;                    {Home}
   Kbd_UpAr = #72;                    {Up Arrow}
   Kbd_PgUp = #73;                    {Page Up}
   Kbd_LfAr = #75;                    {Left Arrow}
   Kbd_RtAr = #77;                    {Right Arrow}
   Kbd_End  = #79;                    {End}
   Kbd_DnAr = #80;                    {Down Arrow}
   Kbd_PgDn = #81;                    {Page Down}
   Kbd_Ins  = #82;                    {Insert}
   Kbd_Del  = #83;                    {Delete}
   Kbd_CLAr = #115;                   {Ctrl-Left Arrow}
   Kbd_CRAr = #116;                   {Ctrl-Right Arrow}
   Kbd_CEnd = #117;                   {Ctrl-End}
   Kbd_CPDn = #118;                   {Ctrl-Page Down}
   Kbd_CHom = #119;                   {Ctrl-Home}
   Kbd_CPUp = #132;                   {Ctrl-Page up}

var

   GS_KeyI_Esc,
   GS_KeyI_Fuc,
   GS_KeyI_Ins,
   GS_KeyI_Ret   : boolean;
   GS_KeyI_Chr   : char;
   GS_KeyI_Str   : string[255];
   EscStrSave    : string;
   AdditionalKeys: string;
   EditADate     : boolean;
   Wait_CR       : boolean;

function  EditString(T : string; x, y, l : integer) : string;
Procedure SetScreenColors(fgn,hcl,bgn,ifgn,ibgn : byte);
Procedure SetHiMode;
Procedure SetIvMode;
Procedure SetNmMode;
Function  GetKey : char;
procedure SoundBell( t,h : word);
procedure WaitForKey;

function  GS_Pick_Line(InxObj: GSP_IndxColl; var sitem: word): GSP_IndxEtry;
function  GS_Pick_Row(InxObj: GSP_IndxColl; var sitem: word): GSP_IndxEtry;
function  GS_FindFiles(pth, fname : string; LookElseWhere : boolean): string;
function  GS_Date_Read(x,y: integer;defdate: longint): longint;
procedure MakeABox(boxname : string);

implementation

var
   CPos    : Word;             {Holds the position within the string}
   Ch      : Char;             {Holds the last character read}
   First   : boolean;          {Flag to detect the first real character}
   Modified: boolean;          {Flag to signal whether the field was}
                               {mofified, or the default was returned}
   Fgnd,
   HiLite,
   Bgnd,
   IFgnd,
   IBgnd        : byte;

   icnt         : longint;
   clth         : word;
   GS_FileDrvCnt : word;
   GS_FileDrvTab : array[0..127] of char;
   regs          : registers;
   cdriv         : byte;
   tdrv          : byte;

procedure Check_Func_Keys;
var i : integer;
begin
   for i := 1 to length(AdditionalKeys) do
      if AdditionalKeys[i] = ch then ch := KBD_Ret;
   case ch of
     Kbd_Home  : CPos := 1;
     Kbd_End   : CPos := Succ(Length(GS_KeyI_Str));
     Kbd_Ins   : begin
                    if not EditADate then GS_KeyI_Ins := not GS_KeyI_Ins;
                 end;
    Kbd_LfAr  : if CPos > 1 then Dec(CPos);
    Kbd_RtAr  : if CPos <= Length(GS_KeyI_Str) then Inc(CPos);
    Kbd_Bsp   : begin
                   if not EditADate then
                   begin
                      Delete(GS_KeyI_Str, Pred(CPos), 1);
                      if CPos > 1 then Dec(CPos);
                   end
                   else
                   begin
                      if (GS_KeyI_Str[CPos] in ['0'..'9']) then
                         GS_KeyI_Str[CPos] := ' ';
                      if CPos > 1 then dec(CPos);
                      if not (GS_KeyI_Str[CPos] in [' ','0'..'9']) then
                         dec(CPos);
                   end;
                end;
    Kbd_Del   : begin
                   if not EditADate then
                      if CPos <= Length(GS_KeyI_Str) then
                         Delete(GS_KeyI_Str, CPos, 1);
                 end;
    Kbd_Tab,                  {Tab Key}
    Kbd_Rtb,                  {Shift-Tab key}
    Kbd_UpAr,                 {Up Arrow}
    Kbd_DnAr,                 {Down Arrow}
    Kbd_PgUp,                 {Page Up}
    Kbd_PgDn,                 {Page Down}
    Kbd_CEnd,                 {Ctrl-End}
    Kbd_CHom,                 {Ctrl-Home}
    Kbd_Ret   : begin         {Return}
                   GS_KeyI_Ret := true;   {Set Return Flag true}
                   Ch := Kbd_Ret;
                end;
    Kbd_Esc   : begin         {Escape Key causes an exit with the}
                              {original default value returned}
                   EscStrSave := GS_KeyI_Str;
                   GS_KeyI_Str := '';
                   GS_KeyI_Esc := True;
                end;
   end;
end;

function EditString(T : string; x, y, l : integer) : string;
var
   dix : integer;
begin
   GS_KeyI_Ins := True;               {Start in insert mode}
   if EditADate then GS_KeyI_Ins := false;
   GS_KeyI_Esc := False;              {Set the Escape flag false}
   GS_KeyI_Ret := false;              {Set Return flag false}
   Modified := false;                 {Flag for field not modified}
   First := True;                     {Flag set for no characters yet entered}
   GS_KeyI_Str := T;                  {Store default value in work string}
   CPos := 1;                         {Set cursor position on line to start}
   repeat
      gotoxy(x,y);                    {Go to proper location on screen}
      write(GS_KeyI_Str,'':l-length(GS_KeyI_Str));
                                      {Display the work string}
      GotoXY(CPos+x-1, y);            {Go to current position in the string}
      Ch := GetKey;                   {Get the next keyboard entry}
      if (GS_KeyI_Fuc) or (Ch in [#0..#31]) then
                                      {See if function key or control char}
      begin
         Check_Func_Keys;             {If it is, go process it.}
      end
      else                            {Otherwise add character to the string}
      begin
         if EditADate and ((Ch < '0') or (Ch > '9')) then
            SoundBell(BeepTime,BeepFreq)
         else
         begin
            if First then
            begin
               GS_KeyI_Str := '';
               if EditADate then
               begin
                  GS_KeyI_Str := '          ';
                  GS_KeyI_Str[0] := chr(length(T));
                  for dix := 1 to length(T) do
                     if not (T[dix] in [' ','0'..'9']) then
                        GS_KeyI_Str[dix] := T[dix];
               end;
            end;
            if (GS_KeyI_Ins) then Insert(Ch, GS_KeyI_Str, CPos)
               else if CPos > Length(GS_KeyI_Str) then
                  GS_KeyI_Str := GS_KeyI_Str + Ch
                     else GS_KeyI_Str[CPos] := Ch;
            Inc(CPos);             {Step to the next location in the string}
            if EditADate and not (T[CPos] in [' ','0'..'9']) then
               inc(CPos);
         end;
      end;
      First := False;                 {Set first character flag to false}
      if length(GS_KeyI_Str) > l then {If string is longer than allowed}
      begin
         SoundBell(BeepTime,BeepFreq);
         delete(GS_KeyI_Str,length(GS_KeyI_Str),1);
                                      {Remove the last character in the string}
         dec(CPos);                   {Back up one position}
      end;
      if (CPos > l) then
         if (not Wait_CR) and (Ch <> Kbd_End) then
         begin
            Ch := Kbd_Ret;
            GS_KeyI_Ret := true;      {If field is full and no need to wait}
         end                          {for a carriage return, simulate one}
         else CPos := l;
   until (Ch = Kbd_Ret) or (Ch = Kbd_Esc);
                                      {Continue until Return or Escape pressed}
   if T = GS_KeyI_Str then Modified := false else Modified := true;
   if GS_KeyI_Esc then EditString := T else
                       EditString := GS_KeyI_Str;
                                      {If Escape key pressed, then return the}
                                      {default value.  Otherwise return work}
                                      {string}
   AdditionalKeys := '';
end; { EditString }

Procedure SetScreenColors(fgn,hcl,bgn,ifgn,ibgn : byte);
begin
   FGnd := fgn;
   HiLite := hcl;
   BGnd := bgn;
   IFgnd := ifgn;
   IBGnd := ibgn;
end;

Procedure SetHiMode;
begin
   TextColor(HiLite);
   TextBackground(Bgnd);
end;

Procedure SetIvMode;
begin
   TextColor(IFgnd);
   TextBackground(IBgnd);
end;

Procedure SetNmMode;
begin
   TextColor(Fgnd);
   TextBackground(Bgnd);
end;

procedure SoundBell( t,h : word);
begin
   Sound(h);
   Delay(t);
   NoSound;
end;

procedure WaitForKey;
var
   c  : char;
begin
   c := GetKey;
end;

Function GetKey : char;
var
   ch: char;
begin
  Ch := ReadKey;                      {Use TP ReadKey Function}
  If (Ch = #0) then                   {It must be a function key }
  begin
    Ch := ReadKey;                    {So read the function code}
    GS_KeyI_Fuc := true;              {Set function flag}
  end
  else GS_KeyI_Fuc := false;
  GS_KeyI_Chr := Ch;                  {Save in a global variable for general}
                                      {principle.}
  GetKey := Ch;                       {Return character}
end;

procedure MakeABox(boxname : string);
var
   x, q      : integer;
   s         : string;
   x1,
   y1,
   x2,
   y2     : integer;

begin
   x1 := lo(WindMin)+1;
   x2 := lo(WindMax)+1;
   y1 := hi(WindMin)+1;
   y2 := hi(WindMax)+1;
   SetHiMode;
   window (1,1,80,25);
   FillChar(s[1],80,#205);
   x := succ(x2-x1);
   s[0] := chr(x);
   s[1] := #201;
   if length(boxname) > 0 then
   begin
      if length(boxname) > x-2 then boxname[0] := chr(x-2);
      x := (x-length(boxname)) div 2;
      move(boxname[1],s[x+1],length(boxname));
   end;
   s[length(s)] := #187;
   gotoxy(x1,y1);
   write(s);
   for q := y1+1 to y2-1 do
   begin
      gotoxy(x1,q);
      write(#186);
      gotoxy(x2,q);
      write(#186);
   end;
   gotoxy(x1,y2);
   FillChar(s[1],80,#205);
   s[1] := #200;
   s[0] := chr(pred(length(s)));
   write(s);
   if x2 <> 80 then write(#188);
   window(x1+1,y1+1,x2-1,y2-1);
   SetNmMode;
end;

function GS_Pick_Row(InxObj: GSP_IndxColl; var sitem: word): GSP_IndxEtry;
var
   icnt          : longint;
   clth          : word;
   ci, cw, ct, l : longint;
   cj, cis,
   cih           : longint;
   lins,
   wdth, fl,
   x, y, k       : integer;
   chrr          : char;
   inxptr        : GSP_IndxEtry;
   strng         : string;
begin
   GS_KeyI_Fuc := false;
   clth := InxObj^.KeyLength;
   icnt := InxObj^.KeyCount;
   lins := (hi(windmax)) - (hi(windmin));
   wdth := ((lo(windmax)) - (lo(windmin))) + 1;
   if clth > wdth then clth := wdth;
   l := icnt;
   ci := sitem div lins;
   ci := ci * lins;
   fl := sitem;
   cih := 0;
   cis := 1;
   repeat
      if ci + (lins-1) > l then ci := l - (lins-1);
      if ci < 1 then ci := 1;
      if (not GS_KeyI_Fuc) and (fl <= icnt) then cis := (fl - ci)+1;
      cj := ci;
      if ci <> cih then
      begin
         k := 1;
         cih := ci;
         inxptr := InxObj^.PickKey(ci);
         while cj < ci+lins do
         begin
            if cj <= l then
            begin
               y := k;
               x := 2;
               gotoxy(x,y);
               fillchar(strng[1],clth,' ');
               strng := inxptr^.KeyStr;
               strng[0] := chr(clth);
               write(strng);
               inc(cj);
               inc(k);
               inxptr := InxObj^.PickKey(Next_Record);
            end else cj := 9999;
         end;
         gotoxy(1,lins+1);
         if cj-1 < l then write('':(wdth-10) div 2,'-- more --')
            else write('':wdth-1);
      end;
      fl := ci+cis-1;
      inxptr := InxObj^.PickKey(fl);
      fillchar(strng[1],clth,' ');
      strng := inxptr^.KeyStr;
      strng[0] := chr(clth);
      gotoxy(x,cis);
      SetIvMode;
      write(strng);
      gotoxy(x,cis);
      chrr := GetKey;
      gotoxy(x,cis);
      SetNmMode;
      write(strng);
      if GS_KeyI_Fuc then
      begin
         case chrr of
            Kbd_Home : begin
                        ci := 1;
                        cis := 1;
                     end;
            Kbd_End  : begin
                          ci := l;
                          cis := lins;
                       end;
            Kbd_PgUp : begin
                          ci := ci - lins;
                       end;
            Kbd_PgDn : begin
                          ci := ci + lins;
                       end;
            Kbd_UpAr : begin
                          if cis = 1 then ci := ci - 1 else cis := cis - 1;
                       end;
            Kbd_DnAr : begin
                          if cis = lins then ci := ci + 1 else cis := cis + 1;
                       end;
            else SoundBell(BeepTime, BeepFreq);
         end;
         if cis > l then cis := l;
      end else
         if (chrr <> Kbd_Ret) and (chrr <> Kbd_Esc) then
            SoundBell(BeepTime, BeepFreq);
   until chrr in [Kbd_Ret,Kbd_Esc];
   if chrr = Kbd_Ret then
   begin
      sitem := ci+cis-1;
      GS_Pick_Row := inxptr;
   end else GS_Pick_Row := nil;
end;

function GS_Pick_Line(InxObj: GSP_IndxColl;var sitem: word): GSP_IndxEtry;
var
   icnt          : longint;
   clth          : word;
   inxptr        : GSP_IndxEtry;
   ci,
   y, k, l       : integer;
   chrr          : char;
   strng         : string[255];
begin
   clth := InxObj^.KeyLength;
   icnt := InxObj^.KeyCount;
   l := icnt;
   y := 1;
   ci := succ(pred(sitem));
   if ci > l then ci := l;
   if ci < 1 then ci := 1;
   repeat
      inxptr := InxObj^.PickKey(Top_Record);
      k := 1;
      while k <= l do
      begin
         gotoxy(((k-1)*clth)+1,y);
         fillchar(strng[1],clth,' ');
         strng := inxptr^.KeyStr;
         strng[0] := chr(clth);
         write(strng);
         inc(k);
         inxptr := InxObj^.PickKey(Next_Record);
      end;
      inxptr := InxObj^.PickKey(ci);
      fillchar(strng[1],clth,' ');
      strng := inxptr^.KeyStr;
      strng[0] := chr(clth);
      gotoxy(((ci-1)*clth)+1,y);
      SetIvMode;
      write(strng);
      gotoxy(((ci-1)*clth)+1,y);
      chrr := GetKey;
      gotoxy(((ci-1)*clth)+1,y);
      SetNmMode;
      write(strng);
      if GS_KeyI_Fuc then
      begin
         case chrr of
            Kbd_Home :  ci := 1;
            Kbd_LfAr :  ci := ci - 1;
            Kbd_RtAr :  ci := ci + 1;
            Kbd_End  :  ci := l;
         end;
         if ci > l then ci := 1;
         if ci < 1 then ci := l;
      end;
   until chrr in [Kbd_Ret,Kbd_Esc];
   if chrr = Kbd_Ret then
   begin
      sitem := ci;
      GS_Pick_Line := inxptr;
   end else GS_Pick_Line := nil;
end;

function GS_FindFiles(pth, fname : string; LookElseWhere : boolean): string;
var
   DirObjt : GSP_IndxColl;
   DirEtry : GSP_IndxEtry;
   DirInfo : SearchRec;
   Labl    : string;
   DirNow,
   DirNam,
   DirCur  : PathStr;
   DSt     : DirStr;
   NSt     : NameStr;
   ESt     : ExtStr;
   itms    : integer;
   rfil    : integer;
   rdir    : integer;
   slct    : word;
   lctn    : integer;
   wx1,
   wy1,
   wx2,
   wy2     : integer;

  procedure MakeFileTable;
  var
     i : integer;
     d : string;
     v : char;
     u : byte absolute v;
     b : byte;
   begin
      itms := 0;
      FindFirst(Labl, Archive, DirInfo);
      while DosError = 0 do
      begin
         inc(itms);
         DirObjt^.InsertKey(itms, DirInfo.Name);
         FindNext(DirInfo);
      end;
      rfil := itms;
      if LookElseWhere then
      begin
         DirObjt^.ixSortType := NoSort;
         FindFirst('*.*', Directory, DirInfo);
         while DosError = 0 do
         begin
            if (DirInfo.Attr = directory) and (DirInfo.Name <> '.') then
            begin
               inc(itms);
               for i := 1 to length(DirInfo.Name) do
               begin
                  v := DirInfo.Name[i];
                  if v in ['A'..'Z'] then u := u + 32;
                  DirInfo.Name[i] := v;
               end;
               DirObjt^.InsertKey(itms, DirInfo.Name+'\');
            end;
            FindNext(DirInfo);
         end;
         rdir := itms;
         for i := 0 to pred(GS_FileDrvCnt) do
         begin
            if GS_FileDrvTab[i] = 'P' then
            begin
               inc(itms);
               DirObjt^.InsertKey(itms, chr(i+65)+':\');
            end;
         end;
      end;
   end;

begin
   wx1 := lo(WindMin)+1;
   wx2 := lo(WindMax)+1;
   wy1 := hi(WindMin)+1;
   wy2 := hi(WindMax)+1;
   GetDir(0,DirNow);
   if pth <> '' then
   begin
      FSplit(pth, DSt, NSt, ESt);
      DSt[0] := pred(DSt[0]);
      (*$I-*) ChDir(DSt) (*$I+*);
   end;
   GetDir(0,DirNam);
   DirCur := DirNam;
   repeat
      DirObjt := New(GSP_IndxColl, Init(12, SortUp));
      if DirNam[length(DirNam)] <> '\' then DirNam := DirNam + '\';
      GoToXY(2,(wy2-wy1)+1);
      Write('Dir = ',DirNam);
      ClrEol;
      Labl := DirNam+fname;
      window(wx1,wy1,wx2,wy2-1);
      MakeFileTable;
      if itms > 0 then
      begin
         slct := 1;
         DirEtry := GS_Pick_Row(DirObjt, slct);
         if DirEtry <> nil then
         begin
            Labl := DirEtry^.KeyStr;
         end else Labl := '';
      end else
      begin
         gotoxy(2,2);
         write('No Files');
         WaitForKey;
         slct := 0;
         Labl := '';
      end;
      window(wx1,wy1,wx2,wy2);
      if slct > rfil then
      begin
         if slct > rdir then (*$I-*) ChDir(DirCur) (*$I+*);
         DirNam := Labl;
         DirNam[0] := pred(DirNam[0]);
         (*$I-*) ChDir(DirNam) (*$I+*);
         GetDir(0,DirNam);
         if slct > rdir then DirCur := DirNam;
      end;
      Dispose(DirObjt, Done);
   until slct <= rfil;
   if DirNam[length(DirNam)] <> '\' then DirNam := DirNam + '\';
   if Labl <> '' then GS_FindFiles := DirNam+Labl
      else GS_FindFiles := '';
   if slct = 0 then GS_FindFiles := '-';
   ChDir(DirNow);
end;


function GS_Date_Read(x,y: integer;defdate: longint): longint;
var
   t      : string[10];
   tl : integer;
   okDate : boolean;
   jul    : longint;
begin
   EditADate := true;
   Wait_Cr := true;
   t := GS_Date_View(defdate);
   tl := length(t);
   repeat
      SetIVMode;
      t := EditString(t, x, y, tl);
      SetNmMode;
      if GS_KeyI_Esc then
      begin
         GS_Date_Read := defdate;
         exit;
      end;
      gotoxy(x,y);          {Go to start of field screen position}
      write(t,'':tl-length(t));
                        {Rewrite the string on screen in the original color}
      jul := GS_Date_Juln(t);
      if jul <> GS_Date_JulInv then OkDate := true else OkDate := false;
      if not okDate then SoundBell(BeepTime,BeepFreq);
   until okDate;
   EditADate := false;
   GS_Date_Read := jul;
end;

begin
   AdditionalKeys := '';
   EditADate := false;
   GS_KeyI_Esc := false;
   GS_KeyI_Fuc := false;
   GS_KeyI_Ins := false;
   GS_KeyI_Ret := false;
   GS_KeyI_Chr := #0;                 {Initialize character to null}

                    {Build Drive Table}
   regs.ah := 25;
   regs.Ds := 0;
   regs.Es := 0;
   MsDos(regs);
   cdriv := regs.al;
   regs.dl := cdriv;
   regs.ah := 14;
   regs.Ds := 0;
   regs.Es := 0;
   MsDos(regs);
   GS_FileDrvCnt := regs.al;
   tdrv := 0;
   while tdrv < GS_FileDrvCnt do
   begin
      regs.dl := tdrv;
      regs.ah := 14;
      regs.Ds := 0;
      regs.Es := 0;
      MsDos(regs);
      regs.ah := 25;
      regs.Ds := 0;
      regs.Es := 0;
      MsDos(regs);
      if tdrv = regs.al then GS_FileDrvTab[tdrv] := 'P'
         else GS_FileDrvTab[tdrv] := ' ';
      inc(tdrv);
   end;
   regs.dl := cdriv;
   regs.ah := 14;
   regs.Ds := 0;
   regs.Es := 0;
   MsDos(regs);
end.
