{$X+}
Program Ph1SecG;
{
 Phase 1
 Section G
 Charlie Calvert
}

Uses
  App, Dialogs, Drivers, Menus, MsgBox, Objects, Views;


Const
  WindowNum: Integer = 1;
  cmFileOpen         = 100;
  cmNewWin           = 101;
  cmDraft            = 2001;
  cmLetter           = 2002;
  cmPrintToFile      = 2003;

Type

  PMyDeskTop = ^TMyDeskTop;
  TMyDeskTop = Object(TDeskTop)
    procedure InitBackGround; virtual;
  end;

  PMyInputLine = ^TMyInputLine;
  TMyInputLine = Object(TInputLine)
    function GetPalette: PPalette; virtual;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
    destructor Done; virtual;
    function GetPalette: PPalette; virtual;
  end;

  TMyApp = object(TApplication)
    function GetPalette: PPalette; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure NewWindow;
    procedure Draft;
    procedure Letter;
    procedure PrintToFile;
  end;

procedure TMyDeskTop.InitBackground;
var
  R: TRect;
begin
  GetExtent(R);
  New(Background, Init(R, #219));
end;

procedure NotYetAvailable;
begin
  MessageBox('Not Yet Available',nil,mfOkButton+mfInformation);
end;

function TMyInputLine.GetPalette: PPalette;
const
  CMyInputLine = #4#4#9#3;   
  P: String[Length(CMyInputLine)] = CMyInputLine;
begin
  GetPalette := @P;
end;


{ TMyWindow }
constructor TMyWindow.Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
var
  S: string[3];
  R: TRect;
  Control: PView;
begin
  Str(WindowNo, S);
  TWindow.Init(Bounds, WinTitle + ' ' + S, wnNoNumber);
  R.Assign(2,2,Bounds.B.X - Bounds.A.X - 2, 3);
  Control := New(PMyInputLine, Init(R, 128));
  Insert(Control);
end;

destructor TMyWindow.Done;
begin
  Dec(WindowNum);
  TWindow.Done;
end;

function TMyWindow.GetPalette: PPalette;
const
  CMyWindow = CBlueWindow + #64;
  P: String[Length(CMyWindow)] = CMyWindow;
begin
  GetPalette := @P;
end;


function TMyApp.GetPalette: PPalette;
const
  MyCColor = CColor + #$51;
  AddColor: String[Length(MyCColor)] = MyCColor;
begin
  AddColor[1] := #$51;
  GetPalette := @AddColor;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~N~ew', 'F4', kbF4, cmNewWin, hcNoContext,
      NewSubMenu('~P~rint', hcNoContext, NewMenu(
        NewItem('~D~raft', 'F7', kbF7, cmDraft, hcNoContext,
        NewItem('~L~etter', 'F8', kbF8, cmLetter, hcNoContext,
        NewLine(
        NewItem('~P~rint to File', 'F9', kbF9, cmPrintToFile, hcNoContext,
      nil))))),
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil))))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      nil))),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F4~ New', kbF4, cmNewWin,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil)))),
    nil)
  ));
end;

procedure TMyApp.HandleEvent(var Event: TEvent); 
begin
  TApplication.HandleEvent(Event);
  if Event.What = EvCommand then begin
    case Event.Command of
      cmNewWin: NewWindow;
            cmDraft: Draft;
      cmLetter: Letter;
      cmPrintToFile: PrintToFile;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.NewWindow;
Const
  X:Integer = 40;
  Y:Integer = 5;
Var
  R: TRect;
  MyWindow: PView;
begin
  R.Assign(0,0,X,Y);
  R.Move(Random(X), Random(20));
  MyWindow := New(PMyWindow, Init(R, 'Training Window', WindowNum));
  Inc(WindowNum);
  if ValidView(MyWindow) <> Nil then
    Desktop^.Insert(MyWindow);
end;

procedure TMyApp.Draft;
begin
  NotYetAvailable;
end;

procedure TMyApp.Letter;
begin
  NotYetAvailable;
end;

procedure TMyApp.PrintToFile;
begin
  NotYetAvailable;
end;

Var
  A: TMyApp;

begin
  A.Init;
  A.Run;
  A.Done;
end.