{************************************************}
{ finished simple example                        }
{ Shows how to click on an item in a listbox and }
{ retrieve the value of the selected item        }
{************************************************}

program MyProgram;

uses WinTypes, WinProcs, OWindows, ODialogs, Strings;
{$R ListBox}

const
  cm_Dialog = 105;
  cm_GetInfo = 106;
  id_ListBox = 101;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyDialog =^TMyDialog;
  TMyDialog = Object(TDialog)
      ListBox: PListBox;
    Constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure SetUpWindow; virtual;
    procedure GetInfo(var Msg: TMessage);
      virtual id_First + cm_GetInfo;
    procedure Click(var Msg: TMessage);
      virtual id_First + id_ListBox;
  end;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure CmDialog(var Msg: TMessage);
      virtual cm_First + cm_Dialog;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TMyDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
  TDialog.Init(AParent, AName);
  ListBox := New(PListBox, InitResource(@Self, Id_ListBox));
end;

procedure TMyDialog.SetUpWindow;
var
  S: array[0..200] of Char;
  i: Integer;
begin
  TDialog.SetUpWindow;
  for i := 0 to 20 do begin
    WvsPrintF(S, 'Item: %d', i);
    ListBox^.AddString(S);
  end;
end;

function LongFromWord(LoWord: Word): LongInt; assembler;
asm
  mov dx, 0
  mov ax, LoWord;
end;

procedure TMyDialog.GetInfo(var Msg: TMessage);
var
  S: array[0..32] of Char;
  FSel: Bool;
  L: LongInt;
begin
  FSel := True;
  L := LongFromWord(2);
  StrCopy(S, 'Item');
  SendMessage(GetDlgItem(HWindow, id_ListBox), lb_SelectString, 0, LongInt(@S));
end;

procedure TMyDialog.Click(var Msg: TMessage);
var
  Choice: Integer;
  S: Array[0..100] of Char;
begin
  case Msg.lParamHi of
    lbn_DblClk : begin
      Choice := ListBox^.GetSelIndex;
      ListBox^.GetString(S, Choice);
      MessageBox(HWindow, S, 'asfd', mb_Ok);
    end;
  end;
end;

constructor TMyWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  TWindow.Init(AParent, AName);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
end;

procedure TMyWindow.cmDialog(var Msg: TMessage);
var
  D: PMyDialog;
begin
  D := new(PMyDialog, Init(@Self, 'Dialog_1'));
  Application^.ExecDialog(D);
end;


{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
