
              (* Compiler directives.                               *)
 {$A+,B-,D-,E-,F-,I+,N-,O-,R-,S-,V+}

              (* STACK, HEAP memory directives.                     *)
 {$M 1024, 0, 0}

              (* Example "File moving" program by Guy McLoughlin.   *)
program MoveIt;

uses          (* We need this unit for the paramcount and paramstr  *)
  Dos;        (* routines.                                          *)

const
              (* Carridge-return + Line-feed constant.              *)
  coCrLf = #13#10;

var
              (* Path display width.                                *)
  byDispWidth : byte;

              (* Variable to record the number of files moved.      *)
  woMoveCount : word;

              (* "To", "From" directory-string variables.           *)
  stDirTo,
  stDirFrom  : dirstr;

              (* "To", "From" path-string variables.                *)
  stPathTo,
  stPathFrom,
  stPathTemp : pathstr;

              (* Directory search-record variable.                  *)
  rcSearch : searchrec;

              (* File-variable to move files with.                  *)
  fiTemp : file;


   (***** Handle file errors.                                       *)
   procedure ErrorHandler(byErrorNum : byte; boHalt : boolean);
   begin
     case byErrorNum of

       1 : begin
             writeln(coCrLf, ' (SYNTAX) MOVEIT <path1><filespec>' +
                     ' <path2>');
             writeln(coCrLf, ' (USEAGE) MOVEIT c:\bat\*.bat c:\temp');
             writeln(        '          MOVEIT   \bat\*.bat   \temp');
             writeln(coCrLf,' (Moves all files with the ''.bat'' ' +
                     'extension from )');
             writeln(' (the ''c:\bat'' directory, to ''c:\temp'' ' +
                     'directory.)');
             writeln(coCrLf,' ( Public-domain util by Guy McLoughlin' +
                            ' \ Aug ''92)')
           end;

       2 : writeln(coCrLf, ' Error : <path1> = <path2>');

       3 : writeln(coCrLf,
                         ' Error : Directories must be on same disk');

       4 : writeln(coCrLf, ' <path1> not found ---> ', stDirFrom);

       5 : writeln(coCrLf, ' <path2> not found ---> ', stDirTo);

       6 : writeln(coCrLf, ' Duplicate file found  ------------>  ',
                                   (stDirTo + rcSearch.name), coCrLf);

     end;     (* case byErrorNum.                                   *)

     if boHalt then
       halt

   end;       (* ErrorHandler.                                      *)


   (***** Determine if a file exists.                               *)
   function FileExist(FileName : pathstr) : boolean;
   begin
     FileExist := (FSearch(FileName, '') <> '')
   end;       (* FileExist.                                         *)


   (***** Determine if a directory exists.                          *)
   function DirExist(stDir : dirstr) : boolean;
   var
     woFattr : word;
     fiTemp  : file;
   begin
     assign(fiTemp, (stDir + '.'));
     getfattr(fiTemp, woFattr);
     if (doserror <> 0) then
       DirExist := false
     else
       DirExist := ((woFattr and directory) <> 0)
   end;       (* DirExist.                                          *)


   (***** Returns all valid wildcard names for a specific directory.*)
   (*     When the last file is found, the next call will return an *)
   (*     empty string. To re-set this routine, pass it an empty    *)
   (*     path-string.                                              *)
   (*                                                               *)
   (* NOTE: Standard TP DOS unit must be listed in your program's   *)
   (*       "uses" directive, for this routine to compile.          *)

   function WildCardNames({ input}     stPath   : pathstr;
                                       woAttr   : word;
                          {update} var stDir    : dirstr;
                                   var rcSearch : searchrec)
                          {output}              : pathstr;
   var
              (* Fsplit variables.                                  *)
     stName : namestr;
     stExt  : extstr;
   begin
              (* If the search-record "name" field is empty, then   *)
              (* initialize it with the first matching file found.  *)
     if (rcSearch.name = '') then
       begin
              (* Obtain directory-string from passed path-string.   *)
         fsplit(stPath, stDir, stName, stExt);

              (* Find first match of path-string.                   *)
         findfirst(stPath, woAttr, rcSearch);

              (* If a matching file was found, then return full     *)
              (* path-name.                                         *)
         if (doserror = 0) and (rcSearch.name <> '') then
           WildCardNames := (stDir + rcSearch.name)
         else
              (* No match found, return empty string.               *)
           WildCardNames := ''
       end
     else
              (* Search-record "name" field is not empty, so        *)
              (* continue searching for matches.                    *)
       begin
         findnext(rcSearch);

              (* If no error occurred, then match was found...      *)
         if (doserror = 0) then
           WildCardNames := (stDir + rcSearch.name)
         else
              (* No match found. Re-set search-record "name" field, *)
              (* and return empty path-string.                      *)
           begin
             rcSearch.name := '';
             WildCardNames := ''
           end
       end
   end;


   (***** Pad a string with extras spaces on the right.             *)
   function PadR(stIn : string; bySize : byte) : string;
   begin
     fillchar(stIn[succ(length(stIn))], (bySize - length(stIn)) ,' ');
     inc(stIn[0], (bySize - length(stIn)));
     PadR := stIn
   end;       (* PadR.                                              *)


var           (* Variables used with the TP "FSplit" procedure.     *)
  stName : namestr;
  stExt  : extstr;


              (* Main program execution block.                      *)
BEGIN
              (* If too many or too few parameters, display syntax. *)
  if (paramcount <> 2) then
    ErrorHandler(1, true);

              (* Assign program parameters to string variables.     *)
  stPathFrom := paramstr(1);
  stPathTo   := paramstr(2);

              (* Make sure full path-string is used.                *)
  stPathFrom := fexpand(stPathFrom);
  stPathTo := fexpand(stPathTo);

              (* Make sure that "To" directory ends with '\'        *)
              (* character.                                         *)
  if (stPathTo[length(stPathTo)] <> '\') then
    stPathTo := stPathTo + '\';

              (* Seperate directory-strings from path-strings.      *)
  fsplit(stPathFrom, stDirFrom, stName, stExt);
  fsplit(stPathTo, stDirTo, stName, stExt);

              (* Check if "From" directory-string is the same as    *)
              (* the "To" directory.                                *)
  if (stDirFrom = stDirTo) then
    ErrorHandler(2, true);

              (* Determine the full path display width.             *)
  if (stDirFrom[0] > stDirTo[0]) then
    byDispWidth := length(stDirFrom) + 12
  else
    byDispWidth := length(stDirTo) + 12;

              (* Make sure that files are on the same disk.         *)
  if (stDirFrom[1] <> stDirTo[1]) then
    ErrorHandler(3, true);

              (* Make sure that "From" directory exists.            *)
  if NOT DirExist(stDirFrom) then
    ErrorHandler(4, true);

              (* Make sure that "To" directory exists.              *)
  if NOT DirExist(stDirTo) then
    ErrorHandler(5, true);

              (* Clear the search-record, before begining.          *)
  fillchar(rcSearch, sizeof(rcSearch), 0);

              (* Initialize copy-counter.                           *)
  woMoveCount := 0;

              (* Set file-mode to "read-only".                      *)
  filemode := 0;

  writeln;

              (* Repeat... ...Until (stPathTemp = '').              *)
  repeat
              (* Search for vaild filenames.                        *)
    stPathTemp := WildCardNames(stPathFrom, archive, stDirFrom,
                                                            rcSearch);

              (* If file search was successful, then...             *)
    if (stPathTemp <> '') then

              (* Check if a duplicate file exists in the "To" dir.  *)
      if NOT FileExist(stDirTo + rcSearch.name) then
        begin
              (* Move file from "From" directory to "To" directory. *)
          assign(fiTemp, stPathTemp);
          rename(fiTemp, (stDirTo + rcSearch.name));

              (* Increment move-counter by 1.                       *)
          inc(woMoveCount);

              (* Let the user know that a file has been moved.      *)
          writeln(' ',PadR((stDirFrom + rcSearch.name), byDispWidth),
                ' MOVED TO --->  ', (stDirTo + rcSearch.name));
        end

      else
              (* Duplicate file found in the "To" directory.        *)
        ErrorHandler(6, false)

              (* Repeat... ...Until no more files are found.        *)
  until (stPathTemp = '');

              (* Display the number of files moved.                 *)
  if (woMoveCount = 0) then
    writeln(' NO FILES MOVED TO  --------------->  ', stDirTo)
  else
    writeln(coCrLf, ' ', woMoveCount, ' FILES MOVED')
END.


