program Modal;

{ This program launches a System Modal dialog box.  It's main
  window is hidden.  When the dialog is closed the application
  will shut down.
}
uses
  WinTypes, WinProcs,
  OWindows, ODialogs;

{$R Modal.res}
{ Brings in the resource file for the dialog }

const
  cm_DoDialog = 100;

type
  PMyDialog = ^TMyDialog;
  TMyDialog = object(TDialog)
  { Define your functions for the dialog here. }
  end;

  PMainWin = ^TMainWin;
  TMainWin = object(TWindow)
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure SetUpWindow; virtual;
    procedure CMDoDialog(var Msg: TMessage);
      virtual cm_First + cm_DoDialog;
  end;

  PMainApp = ^TMainApp;
  TMainApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{>>> TMainWin <<<}

constructor TMainWin.Init(AParent: PWindowsObject;
  ATitle: PChar);
begin
  inherited Init(AParent, ATitle);
  CmdShow := sw_Hide;
  { The global variable CmdShow determines how the MainWindow
    appears. It's default value is sw_ShowNormal.
  }
end;

procedure TMainWin.SetUpWindow;
begin
  inherited SetUpWindow;
  PostMessage(HWindow, wm_Command, cm_DoDialog, 0);
  { Sends a message to the window.  This triggers the dialog to
    display.
  }
end;

procedure TMainWin.CMDoDialog(var Msg: TMessage);
var Dlg: PMyDialog;
begin
  { Run the dialog }
  Dlg := New(PMyDialog, Init(@Self, 'DIALOG_1'));
  Application^.ExecDialog(Dlg);

  { Stop the program }
  Application^.Done;
  Halt;
end;

{>>> TMainApp <<<}

procedure TMainApp.InitMainWindow;
begin
  MainWindow := New(PMainWin, Init(nil, 'MainWin'));
end;

var
  MainApp: TMainApp;

begin
  MainApp.Init('Modal');
  MainApp.Run;
  MainApp.Done
end.
