unit MouseUnit;

{ This unit defines an object type mouse_object that provides mouse     }
{ support for Turbo Pascal 5.5 programs.  The routines have been tested }
{ with a MicroSoft serial mouse.  I created this as an educational      }
{ experience for myself in object oriented programming.  If you have    }
{ suggestions or enhancements feel free to contact me.                  }
{                                                                       }
{       Benjamin R Peart                                                }
{       735 N 400 E #29                                                 }
{       Provo, UT  84606                                                }
{       CIS 76645,1041.                                                 }
{                                                                       }
{ If there is any interest in a joystick object and a keyboard object   }
{ that would provide routines similar to those available in the mouse   }
{ object let me know.                                                   }

interface

uses Dos;

type mouse_object = object
        function  Exists : boolean;
        { check if a mouse driver is currently loaded           }

        function  NumberOfButtons : integer;
        { returns the number of available buttons on the mouse  }

        procedure Reset;
        { reset the mouse driver to its defaults                }

        procedure Show;
        { Makes the mouse cursor visible.                       }

        procedure Hide;
        { Makes mouse cursor invisible. Movement and button activity are        }
        { still tracked.                                                        }

        procedure GetStatus(var status, row, column : integer);
        { Get mouse position and status.  Gives button status and       }
        { current position.  status:    1 = left button pressed,        }
        {                               2 = right,                      }
        {                               3 = both.                       }

        procedure MoveTo(new_row, new_column : integer);
        { Position the mouse on the screen.  It wants the pixel         }
        { coordinates, not just character positions.                    }

        procedure Pressed(button : integer; var result : boolean; var count, row, column : integer);
        { Gets pressed info about named button: current status          }
        { (up/down), times pressed since last call, position at most    }
        { recent press.  Resets count and position info. Button 0 is    }
        { left, 1 is right on Microsoft mouse.                          }

        procedure Released(button : integer; var result : boolean; var count, row, column : integer);
        { Gets released info about named button: current status         }
        { (up/down), times released since last call, position at most   }
        { recent press.  Resets count and position info. Button 0 is    }
        { left, 1 is right on Microsoft mouse.                          }

        procedure ColRange(horizontal_min, horizontal_max : integer);
        { Sets min and max horizontal range for mouse cursor. Moves     }
        { cursor inside range if outside when called. Swaps values if   }
        { min and max are reversed.                                     }

        procedure RowRange(vertical_min, vertical_max : integer);
        { Sets min and max vertical range for mouse cursor. Moves       }
        { cursor inside range if outside when called. Swaps values if   }
        { min and max are reversed.                                     }

        procedure GraphCursor(hHot, vHot : integer; mask_segment, mask_offset : word);
        { Sets the graphics cursor's hot spot and mask which defines    }
        { what the graphics cursor will look like.  The cursor hot spot }
        { must be within the range -16 to +16 pixels relative to the    }
        { cursor.  The mask values could be something like:             }
        { xmask : array[1..33] :=                                       }
        {       $07e0, $0000, $0180, $700e, $0000, $1c38, $c003, $0660, }
        {       $f00f, $03c0, $c003, $0660, $0000, $1c38, $0180, $700e, }
        {       $07e0, $0000, $ffff, $0000, $ffff, $0000, $ffff, $0000, }
        {       $ffff, $0000, $ffff, $0000, $ffff, $0000, $ffff, $0000  }
        { defines a graphics cursor like an x.  See the reference       }
        { earlier in this file for the table of the mask values effects }
        { on the screen.                                                }

        procedure TextCursor(cursor_type : integer; arg1, arg2 : word);
        { Sets text cursor type, where 0 = software and 1 = hardware)   }
        { For software cursor, arg1 and arg2 are the screen and cursor  }
        { masks.  For hardware cursor, arg1 and arg2 specify scan line  }
        { start/stop i.e. cursor shape.                                 }

        procedure Motion(var horizontal_count, vertical_count : integer);
        { Reports net motion of cursor since last call to this function.}
        { Returns the motion in "mickeys", always within the range of   }
        { -32768 to +32767.                                             }

        procedure InstallTask(mask, task_segment, task_offset : word);
        { This function sets a subroutine to be conditionally called by }
        { the mouse software.  The condition of execution is defined by }
        { the mask.                                                     }
        {       Bit 0          cursor position changes                  }
        {           1          left button pressed                      }
        {           2          left button released                     }
        {           3          right button pressed                     }
        {           4          right button released                    }
        {           5-15       unused                                   }
        { To disable an interrupt for a specified condition, call       }
        { function again with the corresponding bit set to zero.        }
        { Calling mouse function Reset also resets everything.  The     }
        { subroutine to be called must be a far procedure, must save    }
        { any modified registers, and must not do any dos or bios calls.}

        procedure LightPenOn;
        { Turns on light pen emulation. This is the default condition.  }

        procedure LightPenOff;
        { Turns off light pen emulation.                                }

        procedure Ratio(horizontal, vertical : integer);
        { Sets the mickey / pixel ratio vertically and horizontally.    }
        { Default values are horizontal 8 mickeys to 8 pixels,          }
        { vertically 16 to 8.                                           }

        procedure ConditionOff(x1, y1, x2, y2 : integer);
        { This function is similar to hide_cursor(), but only turns off }
        { the cursor if it is in the area defined when this function is }
        { called.  If this function hides the cursor, Show must be      }
        { called later on to show the cursor again.                     }

        procedure SetThreshold(x : integer);
        { This function sets how fast the mouse must move before its    }
        { relative cursor movements on the screen are doubled.  Default }
        { value is 64 mickeys per second.                               }

end;

implementation

