{ ChrtDemo.pas     --Main program to create business charts
                   --Demonstrates object-oriented programming in
                     Turbo Pascal 5.5.
                   --To run compile the main program and make sure that
                     the units: Chart.pas, Ptypes.pas Dicts.pas are in path.
                     Use the menu command Options->Directories->Unit to
                     change the path if necessary.
                   --The BGI Driver required by your machine and font files
                     must also be in the path.

                   --Written by Zack Urlocker
                     Copyright 1990, The Whitewater Group.
                     All rights reserved.
                   --This program may be freely distributed for
                     non-commercial use.
                   --mzu 06/01/90
}

program ChartDemo;

uses
    Crt, Graph, Charts;

var
   I : Integer;
   Chart0 : Chart;             { Static objects, accessed directly }
   Chart1 : PieChart;
   Chart2 : VBarChart;
   Chart3 : HBarChart;
   Chart4 : V3DBarChart;
   PChart1 : PieChartPtr;      { Dynamic objects, accessed via pointers }
   PChart2 : HBarChartPtr;
   PChart3 : VBarChartPtr;
   PChart4 : V3DBarChartptr;

{ Prompt the user to press return and clear the screen. }
procedure Pause;
var Ch : Char;
begin
  SetTextJustify(CenterText, BottomText);
  OutTextXY(GetMaxX div 2, GetMaxY-5 , 'Press a key..');
  Ch := ReadKey;
  ClearViewPort;
end;

begin { main }
  DirectVideo := False;     { To use CRT unit with Graph unit }

  Chart1.Init;
  Chart2.Init;
  Chart3.Init;
  Chart4.Init;

  Chart1.SetName('Chart1');
  Chart1.SetLoc(0, 0, GetMaxX div 2, GetMaxY Div 2);
  Chart1.Add('Jan', 3);
  Chart1.Add('Feb', 10);
  Chart1.Add('Mar', 15);
  Chart1.Add('Apr', 20);
  Chart1.Add('May', 12);
  Chart1.Add('June', 10);
  Chart1.Add('July', 15);
  Chart1.SetColor(Green);
  Chart1.Draw;

  Chart2.SetName('Chart2');
  Chart2.SetLoc((GetMaxX div 2) + 5, 0, GetMaxX, GetMaxY div 2);
  Chart2.Add('Jan', 3);
  Chart2.Add('Feb', 2);
  Chart2.Add('Mar', 4);
  Chart2.Add('Apr', 2);
  Chart2.Add('May', 1);
  Chart2.Add('June', 3);
  Chart2.Add('July', 2);
  Chart2.SetColor(Red);
  Chart2.Draw;

  Chart3.SetName('Chart3');
  Chart3.SetLoc(0, (GetMaxY div 2) + 5, GetMaxX div 2, GetMaxY - 20);
  Chart3.Add('Jan', 3);
  Chart3.Add('Feb', 5);
  Chart3.Add('Mar', 5);
  Chart3.Add('Apr', 2);
  Chart3.Add('May', 2);
  Chart3.Add('June', 3);
  Chart3.Add('July', 2);
  Chart3.SetColor(LightBlue);
  Chart3.Draw;

  Chart4.SetName('Chart4');
  Chart4.SetLoc((GetMaxX div 2) + 5, (GetMaxY div 2) + 5,
                 GetMaxX , GetMaxY - 20);
  Chart4.Add('Jan', 3);
  Chart4.Add('Feb', 5);
  Chart4.Add('Mar', 5);
  Chart4.Add('Apr', 2);
  Chart4.Add('May', 2);
  Chart4.Add('June', 3);
  Chart4.Add('July', 2);
  Chart4.SetColor(Yellow);
  Chart4.Draw;

  pause;


  writeLn('Pointers...');

  new(PChart1, Init);
  new(PChart2, Init);
  new(PChart3, Init);
  new(PChart4, Init);

  if (PChart1 = nil) or (PChart2 = nil) or
     (Pchart3 = nil) or (PChart4 = nil) then
     begin
       writeLn('**Heap allocation error!');
       writeLn('**Press return.');
       readLn;
       halt(1);
     end;

  PChart1^.SetName('PChart1');
  PChart1^.SetLoc(0, 0, GetMaxX div 2, GetMaxY Div 2);
  PChart1^.Add('Jan', 3);
  PChart1^.Add('Feb', 10);
  PChart1^.Add('Mar', 15);
  PChart1^.Add('Apr', 20);
  PChart1^.Add('May', 12);
  PChart1^.Add('June', 10);
  PChart1^.Add('July', 15);
  PChart1^.SetColor(Green);
  PChart1^.Draw;

  PChart2^.SetName('PChart2');
  PChart2^.SetLoc((GetMaxX div 2) + 5, 0, GetMaxX, GetMaxY div 2);
  PChart2^.Add('Jan', 3);
  PChart2^.Add('Feb', 2);
  PChart2^.Add('Mar', 4);
  PChart2^.Add('Apr', 2);
  PChart2^.Add('May', 1);
  PChart2^.Add('June', 3);
  PChart2^.Add('July', 2);
  PChart2^.SetColor(Red);
  PChart2^.Draw;

  PChart3^.SetName('PChart3');
  PChart3^.SetLoc(0, (GetMaxY div 2) + 5, GetMaxX div 2, GetMaxY - 20);
  PChart3^.Add('Jan', 3);
  PChart3^.Add('Feb', 5);
  PChart3^.Add('Mar', 5);
  PChart3^.Add('Apr', 2);
  PChart3^.Add('May', 2);
  PChart3^.Add('June', 3);
  PChart3^.Add('July', 2);
  PChart3^.SetColor(LightBlue);
  PChart3^.Draw;

  PChart4^.SetName('PChart4');
  PChart4^.SetLoc((GetMaxX div 2) + 5, (GetMaxY div 2) + 5,
                 GetMaxX , GetMaxY - 20);
  PChart4^.Add('Jan', 3);
  PChart4^.Add('Feb', 5);
  PChart4^.Add('Mar', 5);
  PChart4^.Add('Apr', 2);
  PChart4^.Add('May', 2);
  PChart4^.Add('June', 3);
  PChart4^.Add('July', 2);
  PChart4^.SetColor(Yellow);
  PChart4^.Draw;

  Pause;

  { Dispose of all pointer objects }

  PChart1^.Done;
  PChart2^.Done;
  PChart3^.Done;
  PChart4^.Done;

  { Test use of streams for I/O }

  Chart2.Write('Chart2.cht');
  Chart0.Read('Chart2.cht');
  Chart2:=VBarChart(Chart0);

  { Move some charts around }

  Chart1.SetLoc(10, 10, GetMaxX-20, GetMaxY - 20);
  Chart1.Draw;
  Pause;

  Chart2.SetLoc(0, 0, 80, 80);
  Chart2.Draw;
  for I:= 1 to 18 do
    begin
      Delay(10);
      Chart2.Move(I*5, I*5, 80+I*20, 80+I*20);
    end;

  Pause;

end.  { main }
