{ Sample Turbo Pascal 5.5 program demonstrating use of object libraries.
  Uses Object Professional objects for windows, menus.  }

{$D-,L-,A-,B-,E+,F+,I+,N-,O+,R+,S+,V-}

Unit DIALOGS;

Interface

uses FileObj, EmpObj, PayScr;

Procedure RunDeleteDialog(var EmpMastFile : MasterFile);
Procedure RunChangeDialog(var EmpMastFile : MasterFile);

Implementation

uses DOS, OpCrt, OpString, OpFrame, OpWindow, OpKey,
     ULRoot, ULDial;

var
  Header : string;
  Msg : string;
  Choices : string;
  Prompt : string;
  Len : byte absolute Prompt;
  EditSt : string;
  EN : integer;
  ValCode : integer;
  ExitCode : word;
  TimeOut : word;
  N : longint;
  InputDialog : DialogBox;
  Error : word;


Procedure RunModalDialog;
begin
  with ULRootColorSet do
  TextAttr := ColorMono(HotSpotColor, HotSpotMono);
  if not InputDialog.Init(1,17,2,8) then
  begin
    WriteLn('Insufficient memory.');
    Halt(1);
  end;
  EditSt := '';
  with InputDialog do
  begin
    AddHeader(Header,heTC);
    AddMessageString('Enter Employee ID');
    AddChoiceString('Ok Cancel');
    AddStringEntryField(' ',1,1,CharStr('X',4),1,10,10,0,EditSt);
    Process;
    ExitCode := GetLastChoice;
    EditSt := GetEditedString;
    Done;
  end;
  {The employee number is in EditSt.  Convert it to an integer.}
  val(EditSt, EN, ValCode);
  {Need to do something if the input was invalid}
end;

Procedure RunDeleteDialog(var EmpMastFile : MasterFile);
begin
  Header := ' Delete Employee ';
  RunModalDialog;
  EmpMastFile.Delete(EN);
end;

Procedure RunChangeDialog(var EmpMastFile : MasterFile);
begin
  Header := ' Change Employee ';
  RunModalDialog;
  ShowChgScr(EmpMastFile, EN);
end;

end.
